<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Permission;
use Illuminate\Support\Facades\DB;

class CreateInventoryPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:inventory-permissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create inventory permissions in the database';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Creating inventory permissions...');

        // Define inventory permissions
        $permissions = [
            // Warehouses
            [
                'name' => 'إدارة المستودعات',
                'slug' => 'manage_warehouses',
                'description' => 'إدارة كاملة للمستودعات',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض المستودعات',
                'slug' => 'view_warehouses',
                'description' => 'عرض المستودعات',
                'group' => 'inventory'
            ],
            [
                'name' => 'إنشاء مستودع',
                'slug' => 'create_warehouse',
                'description' => 'إنشاء مستودع جديد',
                'group' => 'inventory'
            ],
            [
                'name' => 'تعديل مستودع',
                'slug' => 'edit_warehouse',
                'description' => 'تعديل مستودع',
                'group' => 'inventory'
            ],
            [
                'name' => 'حذف مستودع',
                'slug' => 'delete_warehouse',
                'description' => 'حذف مستودع',
                'group' => 'inventory'
            ],

            // Suppliers
            [
                'name' => 'إدارة الموردين',
                'slug' => 'manage_suppliers',
                'description' => 'إدارة كاملة للموردين',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض الموردين',
                'slug' => 'view_suppliers',
                'description' => 'عرض الموردين',
                'group' => 'inventory'
            ],
            [
                'name' => 'إنشاء مورد',
                'slug' => 'create_supplier',
                'description' => 'إنشاء مورد جديد',
                'group' => 'inventory'
            ],
            [
                'name' => 'تعديل مورد',
                'slug' => 'edit_supplier',
                'description' => 'تعديل مورد',
                'group' => 'inventory'
            ],
            [
                'name' => 'حذف مورد',
                'slug' => 'delete_supplier',
                'description' => 'حذف مورد',
                'group' => 'inventory'
            ],

            // Inventory Items
            [
                'name' => 'إدارة عناصر المخزون',
                'slug' => 'manage_inventory_items',
                'description' => 'إدارة كاملة لعناصر المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض عناصر المخزون',
                'slug' => 'view_inventory_items',
                'description' => 'عرض عناصر المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'إنشاء عنصر مخزون',
                'slug' => 'create_inventory_item',
                'description' => 'إنشاء عنصر مخزون جديد',
                'group' => 'inventory'
            ],
            [
                'name' => 'تعديل عنصر مخزون',
                'slug' => 'edit_inventory_item',
                'description' => 'تعديل عنصر مخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'حذف عنصر مخزون',
                'slug' => 'delete_inventory_item',
                'description' => 'حذف عنصر مخزون',
                'group' => 'inventory'
            ],

            // Inventory Categories
            [
                'name' => 'إدارة تصنيفات المخزون',
                'slug' => 'manage_inventory_categories',
                'description' => 'إدارة كاملة لتصنيفات المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض تصنيفات المخزون',
                'slug' => 'view_inventory_categories',
                'description' => 'عرض تصنيفات المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'إنشاء تصنيف مخزون',
                'slug' => 'create_inventory_category',
                'description' => 'إنشاء تصنيف مخزون جديد',
                'group' => 'inventory'
            ],
            [
                'name' => 'تعديل تصنيف مخزون',
                'slug' => 'edit_inventory_category',
                'description' => 'تعديل تصنيف مخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'حذف تصنيف مخزون',
                'slug' => 'delete_inventory_category',
                'description' => 'حذف تصنيف مخزون',
                'group' => 'inventory'
            ],

            // Inventory Stock
            [
                'name' => 'إدارة المخزون',
                'slug' => 'manage_inventory_stock',
                'description' => 'إدارة كاملة للمخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض المخزون',
                'slug' => 'view_inventory_stock',
                'description' => 'عرض المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'تعديل المخزون',
                'slug' => 'adjust_inventory_stock',
                'description' => 'تعديل كميات المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'نقل المخزون',
                'slug' => 'transfer_inventory_stock',
                'description' => 'نقل المخزون بين المستودعات',
                'group' => 'inventory'
            ],

            // Purchase Orders
            [
                'name' => 'إدارة أوامر الشراء',
                'slug' => 'manage_purchase_orders',
                'description' => 'إدارة كاملة لأوامر الشراء',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض أوامر الشراء',
                'slug' => 'view_purchase_orders',
                'description' => 'عرض أوامر الشراء',
                'group' => 'inventory'
            ],
            [
                'name' => 'إنشاء أمر شراء',
                'slug' => 'create_purchase_orders',
                'description' => 'إنشاء أمر شراء جديد',
                'group' => 'inventory'
            ],
            [
                'name' => 'تعديل أمر شراء',
                'slug' => 'edit_purchase_order',
                'description' => 'تعديل أمر شراء',
                'group' => 'inventory'
            ],
            [
                'name' => 'حذف أمر شراء',
                'slug' => 'delete_purchase_order',
                'description' => 'حذف أمر شراء',
                'group' => 'inventory'
            ],
            [
                'name' => 'تأكيد أمر شراء',
                'slug' => 'confirm_purchase_order',
                'description' => 'تأكيد أمر شراء',
                'group' => 'inventory'
            ],
            [
                'name' => 'استلام أمر شراء',
                'slug' => 'receive_purchase_order',
                'description' => 'استلام أمر شراء',
                'group' => 'inventory'
            ],

            // Inventory Transactions
            [
                'name' => 'إدارة حركات المخزون',
                'slug' => 'manage_inventory_transactions',
                'description' => 'إدارة كاملة لحركات المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض حركات المخزون',
                'slug' => 'view_inventory_transactions',
                'description' => 'عرض حركات المخزون',
                'group' => 'inventory'
            ],

            // Inventory Reports
            [
                'name' => 'إدارة تقارير المخزون',
                'slug' => 'manage_inventory_reports',
                'description' => 'إدارة كاملة لتقارير المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'عرض تقارير المخزون',
                'slug' => 'view_inventory_reports',
                'description' => 'عرض تقارير المخزون',
                'group' => 'inventory'
            ],
            [
                'name' => 'تصدير تقارير المخزون',
                'slug' => 'export_inventory_reports',
                'description' => 'تصدير تقارير المخزون',
                'group' => 'inventory'
            ],
        ];

        DB::beginTransaction();

        try {
            $count = 0;
            foreach ($permissions as $permissionData) {
                $permission = Permission::where('slug', $permissionData['slug'])->first();

                if (!$permission) {
                    Permission::create($permissionData);
                    $this->info("Created permission: {$permissionData['name']} ({$permissionData['slug']})");
                    $count++;
                } else {
                    // Update existing permission
                    $permission->update($permissionData);
                    $this->info("Updated permission: {$permissionData['name']} ({$permissionData['slug']})");
                }
            }

            DB::commit();
            $this->info("Successfully created/updated {$count} inventory permissions.");

            return Command::SUCCESS;
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error("Error creating inventory permissions: {$e->getMessage()}");

            return Command::FAILURE;
        }
    }
}
