<?php

namespace App\Console\Commands;

use App\Services\NotificationService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class CheckWarranties extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'maintenance:check-warranties {days=30 : عدد الأيام للتحقق قبل انتهاء الضمان}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'التحقق من المصاعد التي ستنتهي ضماناتها قريباً وإنشاء إشعارات';

    /**
     * خدمة الإشعارات.
     *
     * @var \App\Services\NotificationService
     */
    protected $notificationService;

    /**
     * Create a new command instance.
     *
     * @param  \App\Services\NotificationService  $notificationService
     * @return void
     */
    public function __construct(NotificationService $notificationService)
    {
        parent::__construct();
        $this->notificationService = $notificationService;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('بدء التحقق من انتهاء ضمانات المصاعد...');

        try {
            $days = (int) $this->argument('days');
            $count = $this->notificationService->checkWarrantyExpirations($days);

            $this->info("تم إنشاء {$count} إشعار لضمانات المصاعد التي ستنتهي خلال {$days} يوم.");
            $this->info('تم التحقق من انتهاء ضمانات المصاعد بنجاح.');

            return 0;
        } catch (\Exception $e) {
            $this->error('فشل التحقق من انتهاء ضمانات المصاعد: ' . $e->getMessage());
            Log::error('فشل التحقق من انتهاء ضمانات المصاعد: ' . $e->getMessage());

            return 1;
        }
    }
}
