<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class CheckUserPermission extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:check-permission {username} {permission}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check if a user has a specific permission';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $username = $this->argument('username');
        $permission = $this->argument('permission');

        $user = User::where('username', $username)->first();

        if (!$user) {
            $this->error("User {$username} not found");
            return Command::FAILURE;
        }

        $hasPermission = $user->hasPermission($permission);

        $this->info("User {$username} " . ($hasPermission ? 'has' : 'does not have') . " permission: {$permission}");

        // Check user roles
        $this->info("User roles:");
        foreach ($user->roles as $role) {
            $this->line("- {$role->name} (slug: {$role->slug})");
        }

        return Command::SUCCESS;
    }
}
