<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Permission;
use App\Models\User;

class CheckPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'check:permissions {email?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check permissions for a user or list all permissions';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $email = $this->argument('email');

        if ($email) {
            $user = User::where('email', $email)->first();

            if (!$user) {
                $this->error("User with email {$email} not found");
                return 1;
            }

            $this->info("User: {$user->name} ({$user->email})");
            $this->info("Roles: " . $user->roles->pluck('slug')->implode(', '));

            // Check specific permission
            $hasCreateUsers = $user->hasPermissionTo('create_users');
            $this->info("Has 'create_users' permission: " . ($hasCreateUsers ? 'Yes' : 'No'));

            // Check create_user (singular) permission
            $hasCreateUser = $user->hasPermissionTo('create_user');
            $this->info("Has 'create_user' permission: " . ($hasCreateUser ? 'Yes' : 'No'));

            // List all permissions for this user
            $this->info("All permissions:");
            foreach ($user->getAllPermissions() as $permission) {
                $this->line(" - {$permission->slug}: {$permission->name}");
            }
        } else {
            // List all permissions in the system
            $this->info("All permissions in the system:");
            foreach (Permission::all() as $permission) {
                $this->line(" - {$permission->slug}: {$permission->name}");
            }
        }

        return 0;
    }
}
