<?php

namespace App\Console\Commands;

use App\Services\NotificationService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class CheckDailyMaintenanceSchedules extends Command
{
    /**
     * اسم وتوقيع الأمر.
     *
     * @var string
     */
    protected $signature = 'maintenance:check-daily';

    /**
     * وصف الأمر.
     *
     * @var string
     */
    protected $description = 'التحقق اليومي من جدولة الصيانة وإرسال إشعارات للصيانة المستحقة اليوم';

    /**
     * خدمة الإشعارات.
     *
     * @var \App\Services\NotificationService
     */
    protected $notificationService;

    /**
     * إنشاء مثيل جديد من الأمر.
     *
     * @param  \App\Services\NotificationService  $notificationService
     * @return void
     */
    public function __construct(NotificationService $notificationService)
    {
        parent::__construct();
        $this->notificationService = $notificationService;
    }

    /**
     * تنفيذ الأمر.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('جاري التحقق من جدولة الصيانة اليومية...');

        try {
            // التحقق من الصيانة المستحقة اليوم (0 أيام مقدماً)
            $todayCount = $this->checkTodayMaintenanceSchedules();
            $this->info("تم إنشاء {$todayCount} إشعار للصيانة المستحقة اليوم.");

            // إرسال جميع الإشعارات المعلقة
            $sentCount = $this->notificationService->sendPendingNotifications();
            $this->info("تم إرسال {$sentCount} إشعار معلق.");

            $this->info('تم الانتهاء من التحقق اليومي بنجاح.');
            return 0;
        } catch (\Exception $e) {
            $this->error('حدث خطأ: ' . $e->getMessage());
            Log::error('فشل التحقق اليومي من جدولة الصيانة: ' . $e->getMessage());
            return 1;
        }
    }

    /**
     * التحقق من جدولة الصيانة المستحقة اليوم.
     *
     * @return int عدد الإشعارات التي تم إنشاؤها
     */
    protected function checkTodayMaintenanceSchedules()
    {
        return $this->notificationService->checkTodayMaintenanceSchedules();
    }
}
