<?php

namespace App\Console\Commands;

use App\Services\CustomerNotificationService;
use App\Services\ActivityLogService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class CheckCustomerFollowUpReminders extends Command
{
    /**
     * اسم وتوقيع الأمر.
     *
     * @var string
     */
    protected $signature = 'customers:check-follow-up';

    /**
     * وصف الأمر.
     *
     * @var string
     */
    protected $description = 'التحقق من تذكيرات متابعة العملاء وإرسال الإشعارات';

    /**
     * خدمة إشعارات العملاء.
     *
     * @var \App\Services\CustomerNotificationService
     */
    protected $customerNotificationService;

    /**
     * خدمة تسجيل النشاط.
     *
     * @var \App\Services\ActivityLogService
     */
    protected $activityLogService;

    /**
     * إنشاء مثيل جديد من الأمر.
     *
     * @param  \App\Services\CustomerNotificationService  $customerNotificationService
     * @param  \App\Services\ActivityLogService  $activityLogService
     * @return void
     */
    public function __construct(CustomerNotificationService $customerNotificationService, ActivityLogService $activityLogService)
    {
        parent::__construct();
        $this->customerNotificationService = $customerNotificationService;
        $this->activityLogService = $activityLogService;
    }

    /**
     * تنفيذ الأمر.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('جاري التحقق من تذكيرات متابعة العملاء...');

        try {
            // التحقق من تذكيرات متابعة العملاء
            $reminderCount = $this->customerNotificationService->checkCustomerFollowUpReminders();
            $this->info("تم إنشاء {$reminderCount} إشعار لتذكيرات متابعة العملاء.");

            $this->info('تم الانتهاء من التحقق من تذكيرات متابعة العملاء بنجاح.');

            // تسجيل النشاط باستخدام خدمة ActivityLogService
            $this->activityLogService->log(
                'customer_follow_up_check',
                'تم التحقق من تذكيرات متابعة العملاء',
                null,
                null,
                [
                    'reminder_count' => $reminderCount
                ]
            );

            return 0;
        } catch (\Exception $e) {
            $this->error('حدث خطأ: ' . $e->getMessage());
            Log::error('فشل التحقق من تذكيرات متابعة العملاء: ' . $e->getMessage());
            return 1;
        }
    }
}
