<?php

namespace App\Console\Commands;

use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class AssignAllRolesPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:assign-all {email}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'إعطاء المستخدم جميع الأدوار والصلاحيات';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $email = $this->argument('email');

        $user = User::where('email', $email)->first();

        if (!$user) {
            $this->error("المستخدم غير موجود: {$email}");
            return Command::FAILURE;
        }

        // إعطاء جميع الأدوار
        $roles = Role::all();
        $roleIds = $roles->pluck('id')->toArray();

        // حذف الأدوار الحالية
        DB::table('role_user')->where('user_id', $user->id)->delete();

        // إضافة جميع الأدوار
        foreach ($roleIds as $roleId) {
            DB::table('role_user')->insert([
                'user_id' => $user->id,
                'role_id' => $roleId,
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }

        // إعطاء جميع الصلاحيات
        $permissions = Permission::all();
        $permissionIds = $permissions->pluck('id')->toArray();

        // حذف الصلاحيات الحالية
        DB::table('user_permission')->where('user_id', $user->id)->delete();

        // إضافة جميع الصلاحيات
        foreach ($permissionIds as $permissionId) {
            DB::table('user_permission')->insert([
                'user_id' => $user->id,
                'permission_id' => $permissionId,
                'granted' => true,
                'source' => 'direct',
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }

        $this->info("تم إعطاء المستخدم {$email} جميع الأدوار ({$roles->count()}) والصلاحيات ({$permissions->count()}) بنجاح");

        return Command::SUCCESS;
    }
}
