<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class AddSmartRecommendationsPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'permissions:add-smart-recommendations';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'إضافة صلاحيات نظام التوصيات الذكية للشراء التلقائي';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('جاري إضافة صلاحيات نظام التوصيات الذكية...');

        $this->call('db:seed', [
            '--class' => 'Database\\Seeders\\SmartRecommendationsPermissionsSeeder',
        ]);

        $this->info('تم إضافة صلاحيات نظام التوصيات الذكية بنجاح!');

        return 0;
    }
}
