<?php

namespace App\Console\Commands;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Console\Command;

class AddMaintenancePermissionsToAdmin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'permissions:add-maintenance-to-admin';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add maintenance permissions to admin role';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Adding maintenance permissions to admin role...');

        // الحصول على دور المدير
        $adminRole = Role::where('slug', 'super_admin')
            ->orWhere('slug', 'admin')
            ->orWhere('name', 'like', '%مدير%')
            ->orWhere('name', 'like', '%ادمن%')
            ->orWhere('name', 'like', '%Admin%')
            ->first();

        if (!$adminRole) {
            $this->error('دور المدير غير موجود.');
            $this->info('الأدوار الموجودة:');
            $roles = Role::pluck('name', 'slug')->toArray();
            foreach ($roles as $slug => $name) {
                $this->line("- {$name} ({$slug})");
            }
            return 1;
        }

        $this->info("تم العثور على دور المدير: {$adminRole->name} ({$adminRole->slug})");

        // الحصول على الصلاحيات الخاصة بنظام الصيانة الدورية
        $maintenancePermissions = Permission::where('slug', 'like', '%maintenance%')
            ->where('type', '!=', 'group')
            ->get();

        if ($maintenancePermissions->isEmpty()) {
            $this->error('لم يتم العثور على صلاحيات نظام الصيانة الدورية.');
            return 1;
        }

        // إضافة الصلاحيات إلى دور المدير
        $existingPermissionIds = $adminRole->permissions->pluck('id')->toArray();
        $newPermissionIds = $maintenancePermissions->pluck('id')->toArray();

        $allPermissionIds = array_unique(array_merge($existingPermissionIds, $newPermissionIds));

        $adminRole->permissions()->sync($allPermissionIds);

        $this->info('تم إضافة ' . count($newPermissionIds) . ' صلاحية لنظام الصيانة الدورية إلى دور المدير بنجاح.');

        return 0;
    }
}
