<?php

// Cargar la aplicación
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Obtener todos los registros de journal entries que estén publicados
$entries = \App\Models\JournalEntry::where('is_posted', true)->get();
echo "Total de registros publicados encontrados: " . $entries->count() . "\n\n";

foreach ($entries as $entry) {
    echo "ID: " . $entry->id . " - Número: " . $entry->entry_number . "\n";
    echo "Fecha: " . $entry->entry_date . "\n";
    echo "Descripción: " . $entry->description . "\n";

    // Verificar si tiene un registro en customer_statements
    $statements = \App\Models\CustomerStatement::where('reference_type', 'App\\Models\\JournalEntry')
        ->where('reference_id', $entry->id)
        ->get();

    echo "Registros en customer_statements: " . $statements->count() . "\n";

    if ($statements->count() > 0) {
        foreach ($statements as $statement) {
            echo "  - Statement ID: " . $statement->id . ", Cliente: " . $statement->customer_id . ", Debit: " . $statement->debit . ", Credit: " . $statement->credit . ", Balance: " . $statement->balance . "\n";
        }
    }

    // Analizar los elementos del asiento contable para ver si hay cuentas de clientes
    $items = \App\Models\JournalEntryItem::where('journal_entry_id', $entry->id)->get();
    echo "Elementos del asiento contable: " . $items->count() . "\n";

    $hasCustomerAccount = false;

    foreach ($items as $item) {
        $account = \App\Models\ChartOfAccount::find($item->account_id);

        if (!$account) {
            echo "  - Elemento ID: " . $item->id . " - Cuenta no encontrada\n";
            continue;
        }

        echo "  - Elemento ID: " . $item->id . ", Cuenta: " . $account->account_code . " - " . $account->name . ", Tipo: " . $account->account_type . ", Subtipo: " . $account->sub_type . "\n";
        echo "    Debit: " . $item->debit . ", Credit: " . $item->credit . "\n";

        // Verificar si es una cuenta de cliente (accounts_receivable o customer_receivable)
        if (
            $account->account_type == 'asset' &&
            ($account->sub_type == 'accounts_receivable' || $account->sub_type == 'customer_receivable') &&
            !$account->is_parent
        ) {
            $hasCustomerAccount = true;

            // Intentar extraer el ID del cliente del código de cuenta (AR-{customer_id} o C{customer_id})
            $customerId = null;
            if (strpos($account->account_code, 'AR-') === 0) {
                $customerId = intval(substr($account->account_code, 3));
                $customer = \App\Models\Customer::find($customerId);
                if ($customer) {
                    echo "    *** Cuenta de cliente identificada: Cliente ID " . $customerId . " - " . $customer->name . " ***\n";
                } else {
                    echo "    *** Formato de cuenta de cliente (AR-{id}) detectado, pero el cliente ID " . $customerId . " no existe ***\n";
                }
            } else if (strpos($account->account_code, 'C') === 0) {
                // Intentar extraer el ID del cliente del código de cuenta (C{customer_id})
                $customerId = intval(substr($account->account_code, 1));
                $customer = \App\Models\Customer::find($customerId);
                if ($customer) {
                    echo "    *** Cuenta de cliente identificada (formato C{id}): Cliente ID " . $customerId . " - " . $customer->name . " ***\n";
                } else {
                    // Intentar buscar el cliente por nombre
                    $customerName = str_replace('حساب العميل: ', '', $account->name);
                    $customer = \App\Models\Customer::where('name', 'like', '%' . $customerName . '%')
                        ->orWhere('name_en', 'like', '%' . $customerName . '%')
                        ->first();

                    if ($customer) {
                        echo "    *** Cuenta de cliente identificada por nombre: Cliente ID " . $customer->id . " - " . $customer->name . " ***\n";
                    } else {
                        echo "    *** Cuenta de cliente detectada, pero no se pudo identificar el cliente ***\n";
                    }
                }
            } else {
                echo "    *** Cuenta de cliente detectada, pero no sigue el formato AR-{id} o C{id} ***\n";
            }
        }
    }

    if (!$hasCustomerAccount) {
        echo "  *** No se encontraron cuentas de clientes en este asiento contable ***\n";
    } else if ($statements->count() == 0) {
        echo "  *** Tiene cuentas de clientes pero no tiene registros en customer_statements ***\n";

        // Intentar crear un registro de estado de cuenta para este asiento contable
        try {
            $result = \App\Models\CustomerStatement::createForJournalEntry($entry);

            if ($result) {
                echo "  *** Se creó correctamente un registro de estado de cuenta para el cliente ***\n";
            } else {
                echo "  *** No se pudo crear un registro de estado de cuenta ***\n";
            }
        } catch (\Exception $e) {
            echo "  *** Error al crear el registro de estado de cuenta: " . $e->getMessage() . " ***\n";
        }
    }

    echo "----------------------------------------\n";
}
