<?php
require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // البحث عن المستخدم
    $user = \App\Models\User::where('email', 'fany@fany.com')->first();
    if (!$user) {
        echo "لم يتم العثور على المستخدم fany@fany.com\n";
        exit(1);
    }

    echo "تم العثور على المستخدم: " . $user->name . " (ID: " . $user->id . ")\n";

    // البحث عن دور الفني
    $techRole = \App\Models\Role::where('slug', 'technician')->first();
    if (!$techRole) {
        echo "لم يتم العثور على دور الفني (technician)\n";

        // البحث عن دور الفني باسمه العربي
        $techRole = \App\Models\Role::where('name', 'فني')->first();
        if (!$techRole) {
            echo "لم يتم العثور على دور الفني (فني)\n";
            exit(1);
        }
    }

    echo "تم العثور على دور الفني: " . $techRole->name . " (ID: " . $techRole->id . ")\n";

    // التحقق مما إذا كان المستخدم لديه دور الفني بالفعل
    $hasRole = $user->roles()->where('roles.id', $techRole->id)->exists();
    if ($hasRole) {
        echo "المستخدم لديه دور الفني بالفعل\n";
    } else {
        // إضافة دور الفني للمستخدم
        $user->roles()->syncWithoutDetaching([$techRole->id]);
        echo "تم إضافة دور الفني للمستخدم بنجاح\n";
    }

    // إضافة الصلاحيات المطلوبة لدور الفني
    $permissions = [
        'view_maintenance_notifications',
        'view-maintenance-schedule',
        'view-maintenance-log'
    ];

    foreach ($permissions as $permSlug) {
        $permission = \App\Models\Permission::where('slug', $permSlug)->first();
        if (!$permission) {
            echo "لم يتم العثور على الصلاحية: " . $permSlug . "\n";
            continue;
        }

        $exists = \DB::table('permission_role')
            ->where('permission_id', $permission->id)
            ->where('role_id', $techRole->id)
            ->exists();

        if (!$exists) {
            \DB::table('permission_role')->insert([
                'permission_id' => $permission->id,
                'role_id' => $techRole->id,
                'created_at' => now(),
                'updated_at' => now()
            ]);
            echo "تم إضافة الصلاحية " . $permission->name . " (" . $permSlug . ") لدور الفني\n";
        } else {
            echo "الصلاحية " . $permission->name . " (" . $permSlug . ") موجودة بالفعل لدور الفني\n";
        }
    }

    echo "تم تنفيذ العملية بنجاح\n";
} catch (\Exception $e) {
    echo "حدث خطأ: " . $e->getMessage() . "\n";
    echo "في الملف: " . $e->getFile() . " على السطر: " . $e->getLine() . "\n";
}
