<?php
require_once __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Find manager3 user
$manager3 = \App\Models\User::where('email', 'manager3@manager3.com')->first();

if (!$manager3) {
    echo "User manager3 not found\n";
    exit;
}

echo "Found manager3 with ID: " . $manager3->id . " (Email: " . $manager3->email . ")\n";

// Get the permissions we want to add
$permissionsToAdd = [
    'view_customer_interaction',
    'create_customer_interaction',
    'edit_customer_interaction',
    'delete_customer_interaction',
    'manage_customer_interactions',
    'view_customer_reward',
    'create_customer_reward',
    'edit_customer_reward',
    'delete_customer_reward',
    'manage_customer_rewards'
];

// Check which permissions exist in the database
$existingPermissions = \App\Models\Permission::whereIn('slug', $permissionsToAdd)->get();
$existingPermissionSlugs = $existingPermissions->pluck('slug')->toArray();

echo "Found " . $existingPermissions->count() . " existing permissions\n";

// Find which permissions need to be created
$permissionsToCreate = array_diff($permissionsToAdd, $existingPermissionSlugs);

echo "Need to create " . count($permissionsToCreate) . " new permissions\n";

// Create missing permissions
foreach ($permissionsToCreate as $permSlug) {
    $newPerm = new \App\Models\Permission();
    $newPerm->name = ucwords(str_replace('_', ' ', $permSlug));
    $newPerm->slug = $permSlug;
    $newPerm->description = ucwords(str_replace('_', ' ', $permSlug));
    $newPerm->group = strpos($permSlug, 'customer_interaction') !== false ? 'customer_interaction' : 'customer_reward';
    $newPerm->save();

    echo "Created permission: " . $permSlug . "\n";
}

// Get all permissions again after creating the missing ones
$permissions = \App\Models\Permission::whereIn('slug', $permissionsToAdd)->get();

echo "Total permissions to add: " . $permissions->count() . "\n";

// Add permissions to the user
foreach ($permissions as $permission) {
    // Check if user already has this permission
    $exists = $manager3->permissions()->where('permission_id', $permission->id)->exists();

    if (!$exists) {
        // Add the permission
        $manager3->permissions()->attach($permission->id, [
            'granted' => true,
            'source' => 'direct_assignment'
        ]);
        echo "Added permission: " . $permission->name . "\n";
    } else {
        echo "User already has permission: " . $permission->name . "\n";
    }
}

echo "\nPermissions added successfully!\n";
