<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// إضافة صلاحيات إدارة المصاعد لجميع المستخدمين
$users = App\Models\User::all();
$permission = App\Models\Permission::where('slug', 'manage_elevators')->first();

if ($permission) {
    foreach ($users as $user) {
        $user->permissions()->syncWithoutDetaching([$permission->id]);
        echo "تم إضافة صلاحية إدارة المصاعد للمستخدم: " . $user->name . "\n";
    }
} else {
    echo "لم يتم العثور على صلاحية إدارة المصاعد.\n";

    // إنشاء صلاحية إدارة المصاعد إذا لم تكن موجودة
    $parentPermission = App\Models\Permission::create([
        'name' => 'إدارة المصاعد',
        'slug' => 'manage_elevators',
        'group' => 'elevators',
        'description' => 'إدارة كاملة للمصاعد',
        'level' => 0,
        'path' => null,
        'type' => 'group',
        'resource' => 'elevators',
        'order' => 0,
        'is_active' => true,
    ]);

    // تحديث المسار بعد الإنشاء
    $parentPermission->path = $parentPermission->id;
    $parentPermission->save();

    echo "تم إنشاء صلاحية إدارة المصاعد.\n";

    // إضافة الصلاحية لجميع المستخدمين
    foreach ($users as $user) {
        $user->permissions()->syncWithoutDetaching([$parentPermission->id]);
        echo "تم إضافة صلاحية إدارة المصاعد للمستخدم: " . $user->name . "\n";
    }
}

// إضافة صلاحيات إدارة الشركات لجميع المستخدمين
$companyPermission = App\Models\Permission::where('slug', 'manage_companies')->first();

if ($companyPermission) {
    foreach ($users as $user) {
        $user->permissions()->syncWithoutDetaching([$companyPermission->id]);
        echo "تم إضافة صلاحية إدارة الشركات للمستخدم: " . $user->name . "\n";
    }
} else {
    echo "لم يتم العثور على صلاحية إدارة الشركات.\n";
}

// إضافة صلاحيات إدارة العملاء لجميع المستخدمين
$customerPermission = App\Models\Permission::where('slug', 'manage_customers')->first();

if ($customerPermission) {
    foreach ($users as $user) {
        $user->permissions()->syncWithoutDetaching([$customerPermission->id]);
        echo "تم إضافة صلاحية إدارة العملاء للمستخدم: " . $user->name . "\n";
    }
} else {
    echo "لم يتم العثور على صلاحية إدارة العملاء.\n";
}

echo "تم الانتهاء من إضافة الصلاحيات.\n";
