<?php

// تحميل الإطار
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// البحث عن المستخدم باستخدام الـ ID
$userId = 3; // ID للمستخدم manager3
$user = App\Models\User::find($userId);
if (!$user) {
    echo "لم يتم العثور على المستخدم بالـ ID: $userId\n";
    exit;
}

echo "تم العثور على المستخدم: " . $user->name . " (ID: " . $user->id . ")\n";

// البحث عن الصلاحية
$permission = App\Models\Permission::where('slug', 'view_maintenance_notifications')->first();
if (!$permission) {
    echo "لم يتم العثور على الصلاحية view_maintenance_notifications\n";
    exit;
}

echo "تم العثور على الصلاحية: " . $permission->name . " (ID: " . $permission->id . ")\n";

// استخدام الدالة المتوفرة في النموذج لمنح الصلاحية
try {
    $userPermission = $user->grantPermission($permission);
    echo "تم منح الصلاحية بنجاح\n";
} catch (\Exception $e) {
    echo "حدث خطأ أثناء منح الصلاحية: " . $e->getMessage() . "\n";
}

// إضافة الصلاحيات الأخرى المتعلقة بالإشعارات
$otherPermissions = [
    'create_maintenance_notifications',
    'edit_maintenance_notifications',
    'delete_maintenance_notifications',
    'manage_maintenance_notifications',
    'view_urgent_notifications',
    'manage_notification_settings',
    'view_notification_logs',
    'run_maintenance_notifications',
    'export_notifications'
];

foreach ($otherPermissions as $slug) {
    $perm = App\Models\Permission::where('slug', $slug)->first();
    if ($perm) {
        try {
            $user->grantPermission($perm);
            echo "تم منح الصلاحية $slug بنجاح\n";
        } catch (\Exception $e) {
            echo "حدث خطأ أثناء منح الصلاحية $slug: " . $e->getMessage() . "\n";
        }
    } else {
        echo "لم يتم العثور على الصلاحية $slug\n";
    }
}

echo "تم الانتهاء من إضافة الصلاحيات\n";
