<?php

// تحميل الإعدادات من ملف .env
$env = file_get_contents(__DIR__ . '/.env');
preg_match('/DB_HOST=(.*)/', $env, $db_host);
preg_match('/DB_PORT=(.*)/', $env, $db_port);
preg_match('/DB_DATABASE=(.*)/', $env, $db_database);
preg_match('/DB_USERNAME=(.*)/', $env, $db_username);
preg_match('/DB_PASSWORD=(.*)/', $env, $db_password);

$host = trim($db_host[1]);
$port = trim($db_port[1]);
$database = trim($db_database[1]);
$username = trim($db_username[1]);
$password = trim($db_password[1]);

// إنشاء اتصال بقاعدة البيانات
try {
    $pdo = new PDO("mysql:host=$host;port=$port;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "تم الاتصال بقاعدة البيانات بنجاح.\n";
} catch (PDOException $e) {
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage() . "\n");
}

// التحقق من وجود الأعمدة وإضافتها إذا كانت غير موجودة
try {
    // التحقق من وجود عمود code
    $stmt = $pdo->query("SHOW COLUMNS FROM branches LIKE 'code'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE branches ADD COLUMN code VARCHAR(50) NULL AFTER name_en");
        echo "تم إضافة عمود code بنجاح.\n";
    } else {
        echo "عمود code موجود بالفعل.\n";
    }

    // التحقق من وجود عمود manager_name
    $stmt = $pdo->query("SHOW COLUMNS FROM branches LIKE 'manager_name'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE branches ADD COLUMN manager_name VARCHAR(255) NULL AFTER code");
        echo "تم إضافة عمود manager_name بنجاح.\n";
    } else {
        echo "عمود manager_name موجود بالفعل.\n";
    }

    // التحقق من وجود عمود notes
    $stmt = $pdo->query("SHOW COLUMNS FROM branches LIKE 'notes'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE branches ADD COLUMN notes TEXT NULL AFTER is_active");
        echo "تم إضافة عمود notes بنجاح.\n";
    } else {
        echo "عمود notes موجود بالفعل.\n";
    }

    // التحقق من وجود عمود is_main_branch
    $stmt = $pdo->query("SHOW COLUMNS FROM branches LIKE 'is_main_branch'");
    $hasIsMainBranch = $stmt->rowCount() > 0;

    // التحقق من وجود عمود is_main
    $stmt = $pdo->query("SHOW COLUMNS FROM branches LIKE 'is_main'");
    $hasIsMain = $stmt->rowCount() > 0;

    // إذا كان is_main موجودًا وis_main_branch غير موجود، قم بتغيير اسم العمود
    if ($hasIsMain && !$hasIsMainBranch) {
        $pdo->exec("ALTER TABLE branches CHANGE COLUMN is_main is_main_branch BOOLEAN DEFAULT FALSE");
        echo "تم تغيير اسم عمود is_main إلى is_main_branch بنجاح.\n";
    }
    // إذا كان كلا العمودين غير موجودين، قم بإضافة is_main_branch
    elseif (!$hasIsMain && !$hasIsMainBranch) {
        $pdo->exec("ALTER TABLE branches ADD COLUMN is_main_branch BOOLEAN DEFAULT FALSE AFTER postal_code");
        echo "تم إضافة عمود is_main_branch بنجاح.\n";
    } else {
        echo "عمود is_main_branch موجود بالفعل.\n";
    }

    echo "تم تنفيذ جميع التغييرات بنجاح.\n";
} catch (PDOException $e) {
    echo "حدث خطأ أثناء تنفيذ التغييرات: " . $e->getMessage() . "\n";
}
