<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// إنشاء مجموعة صلاحيات محاضر تسليم المصاعد
$parentPermission = App\Models\Permission::where('slug', 'manage_elevator_deliveries')->first();

if (!$parentPermission) {
    $parentPermission = App\Models\Permission::create([
        'name' => 'إدارة محاضر تسليم المصاعد',
        'slug' => 'manage_elevator_deliveries',
        'group' => 'elevator_deliveries',
        'description' => 'إدارة كاملة لمحاضر تسليم المصاعد',
        'level' => 0,
        'path' => null,
        'type' => 'group',
        'resource' => 'elevator_deliveries',
        'order' => 0,
        'is_active' => true,
    ]);

    // تحديث المسار بعد الإنشاء
    $parentPermission->path = $parentPermission->id;
    $parentPermission->save();

    echo "تم إنشاء مجموعة صلاحيات إدارة محاضر تسليم المصاعد.\n";
}

// إنشاء صلاحيات محاضر تسليم المصاعد
$permissions = [
    [
        'name' => 'عرض محاضر تسليم المصاعد',
        'slug' => 'view_elevator_deliveries',
        'description' => 'عرض قائمة محاضر تسليم المصاعد',
        'type' => 'view',
    ],
    [
        'name' => 'إنشاء محاضر تسليم المصاعد',
        'slug' => 'create_elevator_deliveries',
        'description' => 'إنشاء محاضر تسليم جديدة للمصاعد',
        'type' => 'create',
    ],
    [
        'name' => 'تعديل محاضر تسليم المصاعد',
        'slug' => 'edit_elevator_deliveries',
        'description' => 'تعديل محاضر تسليم المصاعد الموجودة',
        'type' => 'edit',
    ],
    [
        'name' => 'حذف محاضر تسليم المصاعد',
        'slug' => 'delete_elevator_deliveries',
        'description' => 'حذف محاضر تسليم المصاعد',
        'type' => 'delete',
    ],
    [
        'name' => 'طباعة محاضر تسليم المصاعد',
        'slug' => 'print_elevator_deliveries',
        'description' => 'طباعة محاضر تسليم المصاعد',
        'type' => 'print',
    ],
];

// إنشاء الصلاحيات وربطها بالمجموعة الرئيسية
foreach ($permissions as $permData) {
    $permission = App\Models\Permission::where('slug', $permData['slug'])->first();

    if (!$permission) {
        $permission = App\Models\Permission::create([
            'name' => $permData['name'],
            'slug' => $permData['slug'],
            'group' => 'elevator_deliveries',
            'description' => $permData['description'],
            'level' => 1,
            'path' => $parentPermission->id,
            'type' => $permData['type'],
            'resource' => 'elevator_deliveries',
            'order' => 0,
            'is_active' => true,
            'parent_id' => $parentPermission->id,
        ]);

        echo "تم إنشاء صلاحية: " . $permData['name'] . "\n";
    } else {
        echo "الصلاحية موجودة بالفعل: " . $permData['name'] . "\n";
    }
}

// إضافة الصلاحيات للأدوار
$roles = [
    'admin' => ['manage_elevator_deliveries', 'view_elevator_deliveries', 'create_elevator_deliveries', 'edit_elevator_deliveries', 'delete_elevator_deliveries', 'print_elevator_deliveries'],
    'branch_manager' => ['view_elevator_deliveries', 'create_elevator_deliveries', 'edit_elevator_deliveries', 'print_elevator_deliveries'],
    'technician' => ['view_elevator_deliveries', 'print_elevator_deliveries'],
    'accountant' => ['view_elevator_deliveries', 'print_elevator_deliveries'],
    'user' => ['view_elevator_deliveries'],
];

foreach ($roles as $roleSlug => $permissionSlugs) {
    $role = App\Models\Role::where('slug', $roleSlug)->first();

    if ($role) {
        foreach ($permissionSlugs as $permSlug) {
            $perm = App\Models\Permission::where('slug', $permSlug)->first();

            if ($perm) {
                // التحقق من وجود العلاقة قبل الإضافة
                $exists = DB::table('permission_role')
                    ->where('permission_id', $perm->id)
                    ->where('role_id', $role->id)
                    ->exists();

                if (!$exists) {
                    DB::table('permission_role')->insert([
                        'permission_id' => $perm->id,
                        'role_id' => $role->id,
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);

                    echo "تم إضافة صلاحية {$perm->name} لدور {$role->name}\n";
                } else {
                    echo "الصلاحية {$perm->name} موجودة بالفعل لدور {$role->name}\n";
                }
            }
        }
    } else {
        echo "لم يتم العثور على دور {$roleSlug}\n";
    }
}

// مسح ذاكرة التخزين المؤقت للصلاحيات
\Illuminate\Support\Facades\Cache::flush();
echo "تم مسح ذاكرة التخزين المؤقت بنجاح\n";

echo "تم الانتهاء من إضافة صلاحيات محاضر تسليم المصاعد.\n";
