<?php

// تحميل الإطار
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\DB;

// إضافة مجموعات الصلاحيات
$groups = [
    'cash_registers' => 'الخزائن',
    'cash_transactions' => 'معاملات الخزينة',
    'cash_reports' => 'تقارير الخزينة',
];

foreach ($groups as $name => $display_name) {
    try {
        DB::table('permission_groups')->insertOrIgnore([
            'name' => $name,
            'display_name' => $display_name,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "تم إضافة مجموعة الصلاحيات: {$display_name}\n";
    } catch (\Exception $e) {
        echo "خطأ في إضافة مجموعة الصلاحيات: {$display_name} - " . $e->getMessage() . "\n";
    }
}

// إضافة الصلاحيات
$permissions = [
    // صلاحيات الخزائن
    ['name' => 'view_cash_registers', 'display_name' => 'عرض الخزائن', 'group' => 'cash_registers'],
    ['name' => 'create_cash_registers', 'display_name' => 'إضافة خزائن', 'group' => 'cash_registers'],
    ['name' => 'edit_cash_registers', 'display_name' => 'تعديل الخزائن', 'group' => 'cash_registers'],
    ['name' => 'delete_cash_registers', 'display_name' => 'حذف الخزائن', 'group' => 'cash_registers'],
    ['name' => 'manage_cash_registers', 'display_name' => 'إدارة الخزائن', 'group' => 'cash_registers'],

    // صلاحيات معاملات الخزينة
    ['name' => 'view_cash_transactions', 'display_name' => 'عرض معاملات الخزينة', 'group' => 'cash_transactions'],
    ['name' => 'create_cash_transactions', 'display_name' => 'إضافة معاملات الخزينة', 'group' => 'cash_transactions'],
    ['name' => 'edit_cash_transactions', 'display_name' => 'تعديل معاملات الخزينة', 'group' => 'cash_transactions'],
    ['name' => 'delete_cash_transactions', 'display_name' => 'حذف معاملات الخزينة', 'group' => 'cash_transactions'],
    ['name' => 'manage_cash_transactions', 'display_name' => 'إدارة معاملات الخزينة', 'group' => 'cash_transactions'],

    // صلاحيات تقارير الخزينة
    ['name' => 'view_cash_reports', 'display_name' => 'عرض تقارير الخزينة', 'group' => 'cash_reports'],
    ['name' => 'export_cash_reports', 'display_name' => 'تصدير تقارير الخزينة', 'group' => 'cash_reports'],
    ['name' => 'manage_cash_reports', 'display_name' => 'إدارة تقارير الخزينة', 'group' => 'cash_reports'],
];

foreach ($permissions as $perm) {
    try {
        $permission = Permission::firstOrNew(['name' => $perm['name']]);
        if (!$permission->exists) {
            $permission->display_name = $perm['display_name'];
            $permission->group = $perm['group'];
            $permission->save();
            echo "تم إضافة الصلاحية: {$perm['display_name']}\n";
        } else {
            echo "الصلاحية موجودة بالفعل: {$perm['display_name']}\n";
        }
    } catch (\Exception $e) {
        echo "خطأ في إضافة الصلاحية: {$perm['display_name']} - " . $e->getMessage() . "\n";
    }
}

// إضافة الصلاحيات إلى دور المدير
try {
    $adminRole = Role::where('name', 'admin')->first();
    if ($adminRole) {
        foreach ($permissions as $perm) {
            $permission = Permission::where('name', $perm['name'])->first();
            if ($permission && !$adminRole->hasPermission($permission->name)) {
                $adminRole->permissions()->attach($permission->id);
                echo "تم إضافة الصلاحية {$perm['display_name']} إلى دور المدير\n";
            }
        }
    }
} catch (\Exception $e) {
    echo "خطأ في إضافة الصلاحيات إلى دور المدير: " . $e->getMessage() . "\n";
}

echo "تم الانتهاء من إضافة صلاحيات الخزينة بنجاح\n";
