<?php

// تحديد مسار التطبيق
define('LARAVEL_START', microtime(true));

// تحميل الإعدادات
require __DIR__ . '/vendor/autoload.php';

// تهيئة التطبيق
$app = require_once __DIR__ . '/bootstrap/app.php';

// الحصول على خدمة Kernel
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

// تنفيذ أمر البذر لإضافة صلاحيات البنوك
$status = $kernel->call('db:seed', [
    '--class' => 'Database\Seeders\BankingPermissionsSeeder',
    '--force' => true,
]);

// عرض النتيجة
if ($status === 0) {
    echo "تم إضافة صلاحيات نظام البنوك بنجاح!\n";
} else {
    echo "حدث خطأ أثناء إضافة صلاحيات نظام البنوك.\n";
}

// إنهاء التطبيق
$kernel->terminate(null, $status);
