# نظام إدارة المصاعد (Elevators ERP)

## نظرة عامة

نظام إدارة المصاعد هو نظام متكامل لإدارة شركات المصاعد، يشمل إدارة العملاء، المصاعد، عقود الصيانة، الفواتير، المدفوعات، المشاريع، المخزون، والموارد البشرية.

## الميزات الرئيسية

- إدارة العملاء والمواقع
- إدارة المصاعد وبياناتها الفنية
- إدارة عقود الصيانة وجدولتها
- إدارة الفواتير والمدفوعات
- نظام إدارة الأقساط
- إدارة المشاريع والتركيبات
- إدارة المخزون وقطع الغيار
- نظام طلبات المخزون للمشاريع
- إدارة الموارد البشرية والرواتب
- التقارير المالية والإحصائيات
- نظام الإشعارات والتنبيهات
- إدارة المستخدمين والصلاحيات

## المتطلبات الفنية

- PHP 8.0 أو أعلى
- Laravel 9.x
- MySQL 5.7 أو أعلى
- Node.js و NPM (لتطوير واجهة المستخدم)
- Composer (لإدارة اعتمادات PHP)

## التثبيت

1. استنساخ المستودع:
```
git clone https://github.com/yourusername/elevators_erp.git
```

2. تثبيت اعتمادات PHP:
```
composer install
```

3. تثبيت اعتمادات JavaScript:
```
npm install && npm run dev
```

4. إنشاء ملف البيئة:
```
cp .env.example .env
```

5. توليد مفتاح التطبيق:
```
php artisan key:generate
```

6. تكوين قاعدة البيانات في ملف .env

7. تشغيل الترحيلات وبذر البيانات:
```
php artisan migrate --seed
```

8. تشغيل الخادم المحلي:
```
php artisan serve
```

## نظام إدارة الأقساط

تم إضافة نظام إدارة الأقساط لتسهيل متابعة أقساط الفواتير وتحصيلها. يتضمن النظام:

- إنشاء وإدارة أقساط الفواتير
- تسجيل دفعات الأقساط
- متابعة الأقساط المستحقة والمتأخرة
- إرسال تذكيرات للعملاء بالأقساط المستحقة
- تقارير وإحصائيات الأقساط

### الأوامر المجدولة

تم إضافة الأوامر التالية للتشغيل المجدول:

- `installments:update-overdue`: تحديث حالة الأقساط المتأخرة
- `installments:send-reminders`: إرسال تذكيرات للأقساط المستحقة والمتأخرة

## نظام طلبات المخزون للمشاريع

تم إضافة نظام طلبات المخزون للمشاريع لتسهيل إدارة احتياجات المشاريع من المواد والمعدات. يتضمن النظام:

- إنشاء طلبات مخزون للمشاريع
- تحديد المواد المطلوبة والكميات والمستودعات
- ربط الطلبات بمراحل ومهام المشروع
- التحقق من توفر المخزون قبل تقديم الطلب
- دورة اعتماد متكاملة (إنشاء، اعتماد، رفض، تنفيذ)
- تتبع حالة الطلبات
- تقارير استهلاك المخزون للمشاريع

### الأدوار والصلاحيات

تم تعريف الصلاحيات التالية للنظام:

- **view_project_inventory_requests**: عرض طلبات المخزون
- **create_project_inventory_requests**: إنشاء طلبات مخزون جديدة
- **edit_project_inventory_requests**: تعديل طلبات المخزون
- **delete_project_inventory_requests**: حذف طلبات المخزون
- **approve_project_inventory_requests**: اعتماد طلبات المخزون
- **reject_project_inventory_requests**: رفض طلبات المخزون
- **fulfill_project_inventory_requests**: تنفيذ طلبات المخزون
- **view_project_inventory_reports**: عرض تقارير استهلاك المخزون

للمزيد من المعلومات، يرجى الاطلاع على [وثائق نظام طلبات المخزون للمشاريع](docs/project_inventory_requests.md).

## المساهمة

نرحب بمساهماتكم في تطوير النظام. يرجى اتباع الخطوات التالية:

1. عمل fork للمستودع
2. إنشاء فرع جديد للميزة أو الإصلاح
3. تقديم طلب سحب (Pull Request)

## الترخيص

هذا النظام مرخص بموجب [رخصة MIT](https://opensource.org/licenses/MIT).
