# تحديثات نظام إدارة الموارد البشرية

## الوحدات الجديدة المضافة

تم تطوير وإضافة ثلاث وحدات جديدة لنظام إدارة الموارد البشرية في نظام Elevators ERP:

### 1. نظام إدارة التدريب
نظام متكامل لإدارة التدريب يتيح للشركة تنظيم وتتبع برامج التدريب للموظفين، ويشمل:
- إنشاء وإدارة دورات تدريبية
- تسجيل الموظفين في الدورات
- متابعة حضور وإنجاز الموظفين
- إصدار شهادات إتمام التدريب
- تقارير وإحصائيات عن التدريب

### 2. نظام إدارة الشهادات
نظام لإدارة شهادات الموظفين المهنية والفنية، ويشمل:
- توثيق الشهادات المهنية والفنية للموظفين
- متابعة تواريخ انتهاء الشهادات
- تنبيهات آلية للشهادات التي قاربت على الانتهاء
- إمكانية تحميل نسخ إلكترونية من الشهادات
- تقارير عن الشهادات حسب النوع والموظف

### 3. نظام إدارة مهام الموظفين
نظام لإدارة وتتبع مهام الموظفين، ويشمل:
- إنشاء وتخصيص مهام للموظفين
- تحديد أولويات ومواعيد نهائية للمهام
- متابعة حالة ونسبة إنجاز المهام
- إضافة تعليقات ومرفقات للمهام
- تنبيهات للمهام المتأخرة والقادمة
- تقارير أداء الموظفين في إنجاز المهام

## الملفات الرئيسية

### النماذج (Models)
- `Training.php`: نموذج التدريب
- `TrainingParticipant.php`: نموذج المشاركين في التدريب
- `Certificate.php`: نموذج الشهادات
- `EmployeeTask.php`: نموذج مهام الموظفين
- `EmployeeTaskAssignee.php`: نموذج المكلفين بالمهام
- `EmployeeTaskComment.php`: نموذج تعليقات المهام
- `EmployeeTaskAttachment.php`: نموذج مرفقات المهام

### المتحكمات (Controllers)
- `TrainingController.php`: متحكم التدريب
- `CertificateController.php`: متحكم الشهادات
- `EmployeeTaskController.php`: متحكم مهام الموظفين

### المسارات (Routes)
- `hrm_training.php`: مسارات التدريب والشهادات
- `hrm_tasks.php`: مسارات مهام الموظفين

### العروض (Views)
- `resources/views/hrm/trainings/`: عروض التدريب
- `resources/views/hrm/certificates/`: عروض الشهادات
- `resources/views/hrm/tasks/`: عروض مهام الموظفين

## كيفية استخدام الوحدات الجديدة

### نظام إدارة التدريب
1. الانتقال إلى قائمة "الموارد البشرية" ثم "التدريب"
2. إنشاء تدريب جديد من خلال زر "إضافة تدريب جديد"
3. تعبئة بيانات التدريب واختيار الموظفين المشاركين
4. متابعة حالة المشاركين وتحديثها من صفحة تفاصيل التدريب
5. إصدار شهادات للمشاركين الذين أكملوا التدريب بنجاح

### نظام إدارة الشهادات
1. الانتقال إلى قائمة "الموارد البشرية" ثم "الشهادات"
2. إضافة شهادة جديدة من خلال زر "إضافة شهادة جديدة"
3. تعبئة بيانات الشهادة واختيار الموظف
4. رفع نسخة إلكترونية من الشهادة (اختياري)
5. متابعة الشهادات التي قاربت على الانتهاء من خلال صفحة "الشهادات المنتهية أو قاربت على الانتهاء"

### نظام إدارة مهام الموظفين
1. الانتقال إلى قائمة "الموارد البشرية" ثم "المهام"
2. إنشاء مهمة جديدة من خلال زر "إضافة مهمة جديدة"
3. تعبئة بيانات المهمة واختيار الموظفين المكلفين
4. متابعة حالة المهام من صفحة تفاصيل المهمة
5. إضافة تعليقات ومرفقات للمهمة
6. متابعة المهام المتأخرة والقادمة من خلال الصفحات المخصصة

## الميزات المستقبلية المقترحة

### 1. تطوير نظام تقييم الأداء
- تقييم أداء الموظفين بناءً على المهام المنجزة
- تقارير دورية عن أداء الموظفين
- ربط الأداء بالحوافز والمكافآت

### 2. تطوير نظام التطوير المهني
- إنشاء مسارات تطوير مهني للموظفين
- تحديد المهارات المطلوبة لكل مسار
- ربط التدريب والشهادات بالمسار المهني

### 3. تطوير نظام الاقتراحات والابتكار
- إتاحة تقديم اقتراحات وأفكار للموظفين
- تقييم وتنفيذ الاقتراحات المقبولة
- مكافأة الموظفين على الاقتراحات المنفذة