# ميزة إعداد الشركة الأولى للمستخدمين الجدد

## نظرة عامة
تم إضافة نظام إعداد أولي للمستخدمين الجدد الذين يسجلون في النظام لأول مرة بدون شركة مرتبطة بهم.

## المشكلة الأصلية
عند تسجيل مستخدم جديد لأول مرة، كان النظام يحوله مباشرة إلى صفحة قائمة الشركات دون توضيح أو إرشاد، مما يسبب ارتباكاً للمستخدم.

## الحل المُنفذ

### 1. صفحة الإعداد الأولي (First-Time Setup)
- **الملف:** `resources/views/companies/first-time-setup.blade.php`
- **الوصف:** صفحة ترحيبية تظهر للمستخدمين الجدد
- **المحتوى:**
  - رسالة ترحيبية واضحة
  - نص "لا توجد شركات مسجلة حتى الآن"
  - زر كبير "إنشاء شركة جديدة لأول مرة"
  - قسم معلومات يشرح الفوائد بعد إنشاء الشركة
  - تصميم جذاب مع أيقونات Font Awesome

### 2. تعديل DashboardController
- **الملف:** `app/Http/Controllers/DashboardController.php`
- **التعديل:** في دالة `index()`
  ```php
  if (!$company) {
      return view('companies.first-time-setup');
  }
  ```
- **الوظيفة:** عرض صفحة الإعداد الأولي بدلاً من التحويل المباشر

### 3. تعديل CompanyController

#### دالة create()
- **التعديل:** إضافة متغير `$isFirstTimeSetup`
- **المنطق:**
  ```php
  $isFirstTimeSetup = !$user->company_id;
  ```
- **الصلاحيات:** السماح للمستخدمين بدون شركة بإنشاء شركة (بالإضافة لـ super_admin)

#### دالة store()
- **التعديلات الرئيسية:**
  1. التحقق من أن المستخدم لم يقم بإنشاء شركة مسبقاً
  2. ربط المستخدم بالشركة الجديدة (`user->company_id = company->id`)
  3. منح المستخدم دور "company_manager" (أو "admin" كبديل)
  4. التحويل إلى dashboard مع رسالة نجاح مخصصة

- **كود منع التكرار:**
  ```php
  if ($isFirstTimeSetup) {
      $existingCompany = Company::whereHas('users', function($query) use ($user) {
          $query->where('users.id', $user->id);
      })->first();
      
      if ($existingCompany) {
          return redirect()->route('dashboard')
              ->with('error', 'لقد قمت بإنشاء شركة بالفعل.');
      }
  }
  ```

- **كود الربط والصلاحيات:**
  ```php
  if ($isFirstTimeSetup) {
      // ربط المستخدم بالشركة
      $user->company_id = $company->id;
      $user->save();
      
      // منح دور المدير
      $managerRole = \App\Models\Role::where('slug', 'company_manager')->first();
      if (!$managerRole) {
          $managerRole = \App\Models\Role::where('slug', 'admin')->first();
      }
      
      if ($managerRole && !$user->roles->contains($managerRole->id)) {
          $user->roles()->attach($managerRole->id);
      }
      
      return redirect()->route('dashboard')
          ->with('success', 'تم إنشاء الشركة بنجاح! مرحباً بك في نظام إدارة المصاعد.');
  }
  ```

### 4. تعديل صفحة إنشاء الشركة
- **الملف:** `resources/views/companies/create.blade.php`
- **التعديلات:**
  1. تغيير العنوان ديناميكياً حسب `$isFirstTimeSetup`
  2. إضافة رسالة تنبيه معلوماتية للمستخدمين الجدد
  3. إخفاء زر "العودة إلى قائمة الشركات" في حالة الإعداد الأولي
  4. تغيير نص زر الحفظ إلى "إنشاء الشركة والبدء"

## المتطلبات المُنفذة

✅ **المتطلب 1:** إظهار رسالة "لا توجد شركات مسجلة حتى الآن" مع زر "إنشاء شركة جديدة لأول مرة"

✅ **المتطلب 2:** عند إنشاء الشركة، يتم ربط المستخدم بها تلقائياً ومنحه صلاحيات مدير

✅ **المتطلب 3:** يحق لكل مستخدم إنشاء شركة واحدة فقط، بعدها يختفي الزر

## تدفق العمل (Workflow)

1. **مستخدم جديد يسجل دخول:**
   - النظام يتحقق من وجود شركة مرتبطة
   - إذا لم توجد شركة → عرض صفحة `first-time-setup`

2. **المستخدم يضغط على "إنشاء شركة جديدة لأول مرة":**
   - الانتقال إلى صفحة إنشاء الشركة
   - عرض رسالة ترحيبية خاصة
   - إخفاء زر العودة إلى قائمة الشركات

3. **المستخدم يملأ بيانات الشركة ويضغط "إنشاء الشركة والبدء":**
   - النظام يتحقق من عدم وجود شركة سابقة
   - إنشاء الشركة الجديدة
   - ربط المستخدم بالشركة (`company_id`)
   - منح دور "company_manager" أو "admin"
   - التحويل إلى dashboard مع رسالة نجاح

4. **محاولة إنشاء شركة ثانية:**
   - النظام يرفض ويعرض رسالة "لقد قمت بإنشاء شركة بالفعل"
   - التحويل إلى dashboard

## الملفات المُنشأة

- `resources/views/companies/first-time-setup.blade.php` (جديد)

## الملفات المُعدلة

1. `app/Http/Controllers/DashboardController.php`
2. `app/Http/Controllers/CompanyController.php`
3. `resources/views/companies/create.blade.php`

## ملاحظات تقنية

### نظام الأدوار
- النظام يبحث أولاً عن دور "company_manager"
- إذا لم يجده، يستخدم دور "admin" كبديل
- هذا يضمن التوافق مع أنظمة الأدوار المختلفة

### الأمان
- التحقق من عدم إنشاء أكثر من شركة واحدة
- التحقق من الصلاحيات قبل السماح بإنشاء الشركة
- استخدام `whereHas` للتحقق من العلاقات بشكل آمن

### تجربة المستخدم (UX)
- رسائل واضحة وموجهة
- تصميم جذاب مع أيقونات
- إرشادات واضحة للخطوات التالية
- رسائل نجاح مخصصة

## الاختبار

### سيناريو 1: مستخدم جديد بدون شركة
1. تسجيل دخول مستخدم جديد
2. التحقق من ظهور صفحة الإعداد الأولي
3. الضغط على زر "إنشاء شركة جديدة لأول مرة"
4. ملء بيانات الشركة
5. التحقق من إنشاء الشركة وربط المستخدم بها
6. التحقق من منح صلاحيات المدير

### سيناريو 2: محاولة إنشاء شركة ثانية
1. مستخدم لديه شركة بالفعل
2. محاولة الوصول إلى صفحة إنشاء شركة
3. التحقق من رفض النظام وعرض رسالة خطأ

### سيناريو 3: Super Admin
1. تسجيل دخول super admin
2. التحقق من إمكانية إنشاء شركات متعددة
3. التحقق من عدم تأثر الوظائف الأصلية

## التحسينات المستقبلية المقترحة

1. **Wizard متعدد الخطوات:**
   - خطوة 1: معلومات الشركة الأساسية
   - خطوة 2: إنشاء الفرع الأول
   - خطوة 3: الإعدادات الأولية

2. **جولة إرشادية (Tour):**
   - عرض جولة تعريفية بعد إنشاء الشركة
   - شرح الميزات الأساسية للنظام

3. **فيديو تعليمي:**
   - إضافة فيديو قصير يشرح كيفية البدء

4. **قوالب جاهزة:**
   - توفير قوالب جاهزة لأنواع مختلفة من الشركات

## الدعم والمساعدة

إذا واجهت أي مشاكل أو كان لديك اقتراحات، يرجى التواصل مع فريق التطوير.

---

**تاريخ الإنشاء:** 2025-10-01  
**الإصدار:** 1.0  
**الحالة:** مُنفذ ومُختبر ✅