# نظام إنشاء الحسابات الأساسية التلقائي

## 📋 الوصف

تم إضافة نظام تلقائي لإنشاء الحسابات الأساسية في دليل الحسابات عند فتح صفحة دليل الحسابات لأول مرة.

## ✨ الميزات

### 1. التحقق التلقائي
- عند فتح صفحة دليل الحسابات (`/chart-of-accounts`)
- يتم التحقق تلقائياً من وجود حسابات للشركة الحالية
- إذا لم يكن هناك أي حسابات، يتم إنشاء الحسابات الأساسية تلقائياً

### 2. الحسابات الأساسية المُنشأة

يتم إنشاء 5 حسابات رئيسية:

| رمز الحساب | اسم الحساب | النوع | الوصف |
|-----------|------------|------|-------|
| **1000** | الأصول | Assets | حساب رئيسي للأصول |
| **2000** | الخصوم | Liabilities | حساب رئيسي للخصوم |
| **3000** | رأس المال وحقوق الملكية | Equity | حساب رئيسي لرأس المال وحقوق الملكية |
| **4000** | الإيرادات | Revenues | حساب رئيسي للإيرادات |
| **5000** | المصروفات | Expenses | حساب رئيسي للمصروفات |

### 3. خصائص الحسابات الأساسية

جميع الحسابات الأساسية تحتوي على:
- ✅ **نوع الحساب**: حساب رئيسي (Parent Account)
- ✅ **المستوى**: المستوى الأول (Level 1)
- ✅ **الحساب الأب**: لا يوجد (null)
- ✅ **الرصيد الافتتاحي**: 0
- ✅ **الرصيد الحالي**: 0
- ✅ **العملة**: ريال سعودي (SAR)
- ✅ **الحالة**: نشط (Active)
- ✅ **معزول حسب الشركة**: كل شركة لها حساباتها الخاصة

## 🔒 الأمان والعزل

### عزل البيانات بين الشركات
- ✅ كل شركة لها حساباتها الأساسية الخاصة
- ✅ يتم ربط الحسابات بـ `company_id` تلقائياً
- ✅ لا يمكن لشركة رؤية أو الوصول لحسابات شركة أخرى
- ✅ التحقق يتم على مستوى الشركة الحالية فقط

### آلية العمل
```php
// 1. التحقق من وجود حسابات للشركة الحالية
$accountsCount = ChartOfAccount::where('company_id', $companyId)->count();

// 2. إذا لم يكن هناك حسابات، إنشاء الحسابات الأساسية
if ($accountsCount === 0) {
    $this->createDefaultAccounts($companyId);
}
```

## 📝 كيفية الاستخدام

### للمستخدم النهائي:
1. قم بتسجيل الدخول إلى النظام
2. انتقل إلى صفحة دليل الحسابات: `/chart-of-accounts`
3. إذا كانت هذه أول مرة تفتح فيها الصفحة:
   - سيتم إنشاء الحسابات الأساسية تلقائياً
   - ستظهر رسالة نجاح: "تم إنشاء الحسابات الأساسية بنجاح! يمكنك الآن إضافة حسابات فرعية."
4. يمكنك الآن إضافة حسابات فرعية تحت كل حساب رئيسي

### للمطور:
الدالة المسؤولة عن إنشاء الحسابات الأساسية:
```php
private function createDefaultAccounts($companyId)
{
    // تعريف الحسابات الأساسية
    $defaultAccounts = [
        // الأصول
        [
            'account_code' => '1000',
            'name' => 'الأصول',
            'name_en' => 'Assets',
            'account_type' => 'asset',
            // ... باقي الخصائص
        ],
        // ... باقي الحسابات
    ];

    // إنشاء الحسابات مع ربطها بالشركة
    foreach ($defaultAccounts as $accountData) {
        $accountData['company_id'] = $companyId;
        ChartOfAccount::create($accountData);
    }
}
```

## 🎯 الفوائد

### 1. تسهيل البداية
- لا حاجة لإنشاء الحسابات الأساسية يدوياً
- توفير الوقت والجهد
- تقليل الأخطاء البشرية

### 2. التوحيد والاتساق
- جميع الشركات تبدأ بنفس الهيكل الأساسي
- سهولة الصيانة والدعم
- توحيد المعايير المحاسبية

### 3. المرونة
- يمكن للمستخدم إضافة حسابات فرعية حسب الحاجة
- يمكن تعديل الحسابات الأساسية بعد الإنشاء
- يمكن إضافة حسابات جديدة في أي وقت

## 🔧 التخصيص

### تعديل الحسابات الأساسية
إذا كنت تريد تعديل الحسابات الأساسية، قم بتعديل المصفوفة `$defaultAccounts` في دالة `createDefaultAccounts()`:

```php
$defaultAccounts = [
    [
        'account_code' => '1000',  // رمز الحساب
        'name' => 'الأصول',        // الاسم بالعربية
        'name_en' => 'Assets',     // الاسم بالإنجليزية
        'account_type' => 'asset', // نوع الحساب
        // ... باقي الخصائص
    ],
    // أضف حسابات جديدة هنا
];
```

### إضافة حسابات فرعية افتراضية
يمكنك إضافة حسابات فرعية تحت الحسابات الرئيسية:

```php
// بعد إنشاء الحسابات الرئيسية
$assetsAccount = ChartOfAccount::where('company_id', $companyId)
    ->where('account_code', '1000')
    ->first();

// إنشاء حساب فرعي
ChartOfAccount::create([
    'company_id' => $companyId,
    'account_code' => '1100',
    'name' => 'الأصول المتداولة',
    'name_en' => 'Current Assets',
    'account_type' => 'asset',
    'parent_id' => $assetsAccount->id,
    'level' => 2,
    'is_parent' => false,
    // ... باقي الخصائص
]);
```

## 📊 مثال على الهيكل الناتج

```
دليل الحسابات
├── 1000 - الأصول (Assets)
│   └── [يمكن إضافة حسابات فرعية]
├── 2000 - الخصوم (Liabilities)
│   └── [يمكن إضافة حسابات فرعية]
├── 3000 - رأس المال وحقوق الملكية (Equity)
│   └── [يمكن إضافة حسابات فرعية]
├── 4000 - الإيرادات (Revenues)
│   └── [يمكن إضافة حسابات فرعية]
└── 5000 - المصروفات (Expenses)
    └── [يمكن إضافة حسابات فرعية]
```

## ⚠️ ملاحظات مهمة

1. **التشغيل مرة واحدة فقط**: النظام يتحقق من وجود حسابات قبل الإنشاء، لذلك لن يتم إنشاء حسابات مكررة
2. **العزل الكامل**: كل شركة لها حساباتها الخاصة المعزولة تماماً
3. **الأمان**: جميع العمليات محمية بفحص `company_id`
4. **المرونة**: يمكن تعديل أو حذف الحسابات الأساسية بعد الإنشاء (مع مراعاة القيود المحاسبية)

## 🧪 الاختبار

### اختبار إنشاء الحسابات:
1. قم بإنشاء شركة جديدة
2. قم بتسجيل الدخول كمستخدم من هذه الشركة
3. افتح صفحة دليل الحسابات
4. تحقق من إنشاء الحسابات الأساسية الخمسة

### اختبار العزل:
1. قم بإنشاء شركتين مختلفتين
2. افتح دليل الحسابات لكل شركة
3. تحقق من أن كل شركة لها حساباتها الخاصة
4. تحقق من عدم ظهور حسابات شركة في شركة أخرى

## 📞 الدعم

إذا واجهت أي مشاكل أو كان لديك أسئلة، يرجى التواصل مع فريق التطوير.

---

**تاريخ الإنشاء**: 2025-09-25  
**الإصدار**: 1.0  
**الحالة**: ✅ مُفعّل ويعمل