---
description: Repository Information Overview
alwaysApply: true
---

# نظام إدارة المصاعد (Elevators ERP)

## ملخص
نظام إدارة موارد المؤسسات (ERP) متخصص في إدارة المصاعد، مبني على إطار عمل Laravel. يوفر النظام أدوات شاملة لإدارة صيانة المصاعد، العقود، الفواتير، وعمليات الشركة.

## الهيكل
- **app/**: يحتوي على الكود الأساسي للتطبيق بما في ذلك المتحكمات، النماذج، والخدمات
- **database/**: ملفات ترحيل قاعدة البيانات والبذور
- **resources/**: العروض، الأصول، وملفات اللغة
- **routes/**: تعريفات المسارات
- **public/**: الملفات المتاحة للجمهور
- **storage/**: تخزين التطبيق

### المكونات الرئيسية
- **إدارة المستخدمين**: المصادقة، الأدوار، والصلاحيات
- **إدارة الشركات**: دعم متعدد الشركات مع الفروع
- **إدارة المصاعد**: تتبع وصيانة المصاعد
- **نظام الصيانة**: جدولة وتسجيل أنشطة الصيانة
- **النظام المالي**: الفواتير، المدفوعات، والتقارير المالية
- **إدارة الموارد البشرية**: إدارة الموظفين، الرواتب، والحضور
- **إدارة المشاريع**: إدارة مشاريع تركيب المصاعد ومراحلها

## اللغة والبيئة التشغيلية
**اللغة**: PHP
**الإصدار**: ^8.0.2
**إطار العمل**: Laravel 9.x
**مدير الحزم**: Composer

## الاعتماديات
**الاعتماديات الرئيسية**:
- laravel/framework: ^9.19
- laravel/sanctum: ^3.0
- laravel/tinker: ^2.7
- laravel/ui: ^4.6
- doctrine/dbal: ^4.3
- milon/barcode: ^12.0
- simplesoftwareio/simple-qrcode: ^4.2

**اعتماديات التطوير**:
- fakerphp/faker: ^1.9.1
- laravel/pint: ^1.0
- laravel/sail: ^1.0.1
- phpunit/phpunit: ^9.5.10
- spatie/laravel-ignition: ^1.0

## البناء والتثبيت
```bash
composer install
npm install
npm run build
php artisan migrate
php artisan db:seed
php artisan serve
```

## واجهة المستخدم
**لغة البرمجة**: JavaScript
**نظام البناء**: Vite
**مدير الحزم**: npm

**اعتماديات التطوير**:
- bootstrap: ^5.2.3
- axios: ^1.1.2
- vite: ^4.5.14
- sass: ^1.56.1

**أوامر البناء**:
```bash
npm install
npm run dev   # للتطوير
npm run build # للإنتاج
```

## الاختبار
**إطار العمل**: PHPUnit
**موقع الاختبارات**: tests/
**اتفاقية التسمية**: *Test.php
**أمر التشغيل**:
```bash
php artisan test
```

## قاعدة البيانات
**نوع قاعدة البيانات**: MySQL
**اسم قاعدة البيانات**: elevators_management
**نظام الهجرة**: Laravel Migrations

## نظام إدارة المشاريع

### الحالة الحالية
- **النماذج (Models)**: تم إنشاء جميع نماذج البيانات اللازمة لنظام إدارة المشاريع
- **المتحكمات (Controllers)**: تم إنشاء جميع المتحكمات اللازمة لإدارة المشاريع
- **المسارات (Routes)**: تم تعريف جميع المسارات اللازمة في ملف `installation_projects.php`
- **قاعدة البيانات**: تم إنشاء جميع جداول قاعدة البيانات اللازمة من خلال ملفات الهجرة

### ما يجب إكماله
1. **ملفات العرض (Views)**: لم يتم العثور على ملفات العرض الخاصة بالمشاريع في المجلد `resources/views`. يجب إنشاء صفحات العرض لجميع وظائف نظام إدارة المشاريع.
2. **تفعيل الروابط**: يجب تفعيل الروابط في الشريط الجانبي للتأكد من أنها تعمل بشكل صحيح.
3. **اختبار الوظائف**: بعد إنشاء ملفات العرض، يجب اختبار جميع وظائف نظام إدارة المشاريع.

## الميزات الرئيسية
- إدارة متعددة الشركات
- جدولة وتتبع صيانة المصاعد
- إدارة العقود والفواتير
- نظام إشعارات متقدم
- تقارير مالية شاملة
- إدارة المخزون
- نظام إدارة الموارد البشرية
- نظام إدارة مشاريع تركيب المصاعد