---
description: Repository Information Overview
alwaysApply: true
---

# نظام إدارة شركات المصاعد (Elevators ERP)

## الملخص
نظام متكامل لإدارة شركات المصاعد يتضمن وحدات متعددة لإدارة العملاء، المشاريع، الصيانة، المخزون، الموارد البشرية، والإدارة المالية. النظام مبني بلغة PHP باستخدام إطار العمل Laravel.

## الهيكل الرئيسي
- **app/**: الشيفرة المصدرية للتطبيق
  - **Http/Controllers/**: متحكمات النظام
  - **Models/**: نماذج البيانات
  - **Providers/**: مزودي الخدمات
- **config/**: ملفات الإعدادات
- **database/**: التهجيرات والبذور
- **public/**: الملفات العامة
- **resources/**: الموارد (العروض، اللغات، الأصول)
- **routes/**: مسارات النظام
- **storage/**: ملفات التخزين

## اللغة والبيئة
**اللغة**: PHP 8.x
**إطار العمل**: Laravel 10.x
**نظام إدارة قواعد البيانات**: MySQL
**الواجهة الأمامية**: Bootstrap 4.x, AdminLTE 3.x
**مدير الحزم**: Composer

## المكونات الرئيسية

### إدارة المستخدمين والصلاحيات
- نظام تسجيل الدخول والتحقق
- إدارة الأدوار والصلاحيات
- إدارة الشركات والفروع

### إدارة العملاء
- إدارة بيانات العملاء
- سجل التفاعلات مع العملاء
- إدارة الفرص البيعية

### إدارة المشاريع
- إنشاء وإدارة المشاريع
- تتبع مراحل المشروع
- إدارة المهام والجدولة

### إدارة الصيانة
- جدولة الصيانة الدورية
- إدارة طلبات الصيانة
- تقارير الصيانة

### إدارة المخزون
- إدارة المنتجات والأصناف
- إدارة المخازن
- حركات المخزون (استلام، صرف، تحويل)
- إدارة وحدات القياس

### الإدارة المالية
- إدارة الفواتير
- إدارة المدفوعات
- إدارة الخزائن
- التقارير المالية

## التبعيات الرئيسية
- **spatie/laravel-permission**: إدارة الصلاحيات
- **laravel/ui**: واجهة المستخدم
- **intervention/image**: معالجة الصور
- **maatwebsite/excel**: التعامل مع ملفات Excel
- **barryvdh/laravel-dompdf**: إنشاء ملفات PDF

## أوامر البناء والتشغيل
```bash
# تثبيت التبعيات
composer install

# إنشاء قاعدة البيانات
php artisan migrate

# إضافة البيانات الأولية
php artisan db:seed

# تشغيل الخادم المحلي
php artisan serve
```

## الاختبارات
**إطار الاختبار**: PHPUnit
**موقع الاختبارات**: /tests
**تشغيل الاختبارات**:
```bash
php artisan test
```

## الوثائق
- **README.md**: معلومات عامة عن المشروع
- **CONTRIBUTING.md**: إرشادات المساهمة
- **LICENSE**: رخصة المشروع