---
description: Repository Information Overview
alwaysApply: true
---

# Elevators ERP Information

## Summary
Elevators ERP (نظام إدارة المصاعد) is a comprehensive management system for elevator companies, handling customers, elevators, maintenance contracts, invoices, payments, projects, inventory, and human resources. The system is built with Laravel 9 and supports both English and Arabic interfaces with RTL layout.

## Structure
- **app/**: Core application code (controllers, models, services)
- **database/**: Migrations, seeders, and factories
- **public/**: Publicly accessible files (CSS, JS, images)
- **resources/**: Views, language files, and frontend assets
- **routes/**: Route definitions (web.php and modular route files)

## Language & Runtime
**Language**: PHP
**Version**: 8.0.2 or higher
**Framework**: Laravel 9.x
**Database**: MySQL 5.7 or higher
**Build System**: Composer (PHP), npm/Vite (Frontend)

## Dependencies
**Main Dependencies**:
- laravel/framework (^9.19): Core Laravel framework
- spatie/laravel-permission (^6.21): Role and permission management
- maatwebsite/excel (^3.1): Excel import/export functionality
- simplesoftwareio/simple-qrcode (^4.2): QR code generation
- milon/barcode (^12.0): Barcode generation
- doctrine/dbal (^4.3): Database abstraction layer

**Frontend Dependencies**:
- Bootstrap 5.2.3: CSS framework
- Vite 4.5.14: Frontend build tool
- Axios 1.1.2: HTTP client

## Build & Installation
```bash
# Install PHP dependencies
composer install

# Install JavaScript dependencies
npm install

# Build frontend assets
npm run build

# Set up environment
cp .env.example .env
php artisan key:generate

# Run database migrations and seeders
php artisan migrate --seed
```

## Permission System
The application uses Spatie's Laravel Permission package for role and permission management. Key permissions include:
- view_civil_defense, manage_civil_defense
- view_termination_letters, manage_termination_letters
- view_maintenance_notifications, delete_maintenance_notifications
- view_hrm, manage_hrm

## Main Modules
- **Customer Management**: Customer records, locations, and statements
- **Elevator Management**: Elevator records, types, models, and parts
- **Maintenance System**: Contracts, schedules, and logs
- **Financial System**: Invoices, payments, and financial reports
- **Inventory Management**: Parts, stock management, and inventory requests
- **HRM System**: Employee management, payroll, attendance, and evaluations
- **Project Management**: Installation projects, tasks, and resources
- **Accounting System**: Chart of accounts, journal entries, and financial reports
- **Civil Defense**: Termination letters and compliance documentation

## Multi-Company Architecture
The system uses a multi-tenant architecture where most tables include a `company_id` column to isolate data between different companies. Session-based company selection determines which data is accessible to users.