---
description: تحديث المخزون عند إنشاء أذونات الصرف
alwaysApply: true
---

# تحديث المخزون عند إنشاء أذونات الصرف

## المشكلة

تم اكتشاف مشكلة في نظام المخزون حيث لا يتم تحديث أرصدة المخزون تلقائيًا عند إنشاء أو اعتماد أذونات الصرف. هذا يؤدي إلى عدم دقة أرصدة المخزون في النظام.

## تحليل المشكلة

بعد فحص الكود، تبين أن:

1. **آلية تحديث المخزون** كانت موجودة في النظام ولكن لم تكن مفعلة بشكل صحيح في `InventoryIssueController`.
2. **المشكلة الرئيسية**: عند استخدام نوع المعاملة `'issue'` في جدول `inventory_transactions`، كان يحدث خطأ لأن هذه القيمة غير موجودة في قائمة القيم المسموح بها في تعريف العمود.
3. **القيم المسموح بها** في عمود `transaction_type` هي:
   - `'purchase'`
   - `'sale'`
   - `'transfer'`
   - `'adjustment'`
   - `'return_to_supplier'`
   - `'return_from_customer'`
   - `'maintenance_usage'`
   - `'write_off'`

## الحل المنفذ

### 1. تعديل نوع المعاملة في دالة `updateInventory`

تم تغيير نوع المعاملة من `'issue'` إلى `'maintenance_usage'` لتتوافق مع القيم المسموح بها:

```php
$transaction = new InventoryTransaction();
$transaction->company_id = $companyId;
$transaction->transaction_type = 'maintenance_usage'; // تم تغييرها من 'issue'
$transaction->item_id = $itemId;
$transaction->warehouse_id = $warehouseId;
$transaction->quantity = -$quantity; // قيمة سالبة لأنها عملية صرف
$transaction->reference_number = $issue->issue_number;
$transaction->reference_type = 'inventory_issue';
$transaction->reference_id = $issue->id;
$transaction->created_by = auth()->id();
$transaction->notes = 'تم صرف المخزون من إذن الصرف #' . $issue->issue_number;
$transaction->save();
```

### 2. تعديل نوع المعاملة في دالة `updateInventoryOnEdit`

تم تغيير نوع المعاملة من `'issue'` إلى `'maintenance_usage'` في دالة `updateInventoryOnEdit` أيضًا:

```php
$transaction = new InventoryTransaction();
$transaction->company_id = $companyId;
$transaction->transaction_type = 'maintenance_usage'; // تم تغييرها من 'issue'
$transaction->item_id = $itemId;
$transaction->warehouse_id = $warehouseId;
$transaction->quantity = -$newQuantity; // قيمة سالبة لأنها عملية صرف
$transaction->reference_number = $issue->issue_number;
$transaction->reference_type = 'inventory_issue';
$transaction->reference_id = $issue->id;
$transaction->created_by = auth()->id();
$transaction->notes = 'إضافة عنصر جديد للصرف في إذن الصرف #' . $issue->issue_number;
$transaction->save();
```

## النتيجة

بعد تنفيذ هذه التعديلات:

1. يتم تحديث المخزون تلقائيًا عند إنشاء أذونات الصرف واعتمادها.
2. يتم تحديث المخزون بشكل صحيح عند تعديل أذونات الصرف المعتمدة.
3. يتم توثيق جميع حركات المخزون في جدول `inventory_transactions` بشكل صحيح.
4. تظهر أرصدة المخزون المحدثة في تقرير أرصدة المخزون.

## ملاحظات هامة

1. تم استخدام نوع المعاملة `'maintenance_usage'` لأنه الأقرب لعملية صرف المخزون من المستودع.
2. تم استخدام قيم سالبة للكميات في معاملات المخزون لتمثيل عمليات الصرف (تقليل المخزون).
3. تم تنفيذ جميع عمليات تحديث المخزون داخل معاملات قاعدة البيانات (DB transactions) لضمان تكامل البيانات.
4. تم إضافة رسائل نجاح مناسبة للمستخدم عند إنشاء أو تعديل أذونات الصرف.