---
description: حل مشكلة جدول إذن صرف المخازن المفقود وتعديل نظام الصلاحيات
alwaysApply: true
---

# حل مشكلة جدول إذن صرف المخازن المفقود وتعديل نظام الصلاحيات

## المشكلة

كانت هناك مشكلة عند محاولة الوصول إلى صفحة أذونات صرف المخازن، حيث ظهر الخطأ التالي:
```
SQLSTATE[42S02]: Base table or view not found: 1146 Table 'elevators_management.inventory_issues' doesn't exist
```

## التحليل

1. **ملف الهجرة موجود**: تم التحقق من وجود ملف الهجرة `2023_08_15_000001_create_inventory_issues_table.php` الذي يحتوي على تعريف جدولي `inventory_issues` و `inventory_issue_items`.

2. **نموذج البيانات**: نموذج `InventoryIssue.php` يستخدم حقل `user_id` للإشارة إلى المستخدم الذي أنشأ الإذن، بينما المتحكم `InventoryIssueController.php` يستخدم نفس الحقل `user_id`.

3. **نظام الصلاحيات**: المشروع يستخدم نظام صلاحيات مخصص وليس حزمة `spatie/laravel-permission` القياسية. نموذج `Permission` يستخدم حقول مختلفة مثل `slug` و `description` و `group` بدلاً من `guard_name`.

## الحلول المنفذة

### 1. إنشاء جداول قاعدة البيانات

تم تنفيذ ملف الهجرة المحدد لإنشاء جداول `inventory_issues` و `inventory_issue_items`:
```bash
php artisan migrate --path=database/migrations/2023_08_15_000001_create_inventory_issues_table.php
```

### 2. تعديل ملف بذور الصلاحيات

تم تعديل ملف `InventoryIssuePermissionsSeeder.php` ليتوافق مع نظام الصلاحيات المخصص في المشروع:

- إضافة استيراد نماذج `Permission` و `Role` من مجلد `App\Models` بدلاً من حزمة `spatie/laravel-permission`.
- تعديل هيكل الصلاحيات ليشمل الحقول المطلوبة مثل `type` و `resource` و `level` و `order` و `is_active`.
- إضافة منطق للبحث عن مجموعة المخزون الرئيسية وإنشائها إذا لم تكن موجودة.
- إضافة منطق لتحديث مسار الصلاحيات بعد الإنشاء.
- إضافة منطق لإضافة الصلاحيات لدور المدير ودور مدير المخزون.

### 3. تنفيذ ملف بذور الصلاحيات

يمكن تنفيذ ملف بذور الصلاحيات المعدل باستخدام الأمر:
```bash
php artisan db:seed --class=InventoryIssuePermissionsSeeder
```

## ملاحظات هامة

1. **نظام الصلاحيات المخصص**: المشروع يستخدم نظام صلاحيات مخصص مع العلاقات التالية:
   - `User` -> `Permission` عبر جدول `user_permission`
   - `Role` -> `Permission` عبر جدول `permission_role`
   - التحقق من الصلاحيات يتم عبر دالة `hasPermission` في نموذج `User`

2. **هيكل الصلاحيات**: الصلاحيات في النظام تتبع هيكل هرمي مع:
   - `level`: مستوى الصلاحية في الهيكل الهرمي
   - `path`: مسار الصلاحية في الهيكل الهرمي (مثل "1.2.3")
   - `parent_id`: معرف الصلاحية الأب
   - `type`: نوع الصلاحية (group, action)
   - `resource`: المورد الذي تتعلق به الصلاحية

3. **إضافة الصلاحيات للمستخدمين**: يتم إضافة الصلاحيات للمستخدمين عبر دالة `grantPermission` في نموذج `User`.

## الخطوات القادمة

1. **إنشاء واجهات المستخدم**: إنشاء ملفات العرض (views) لصفحات إذن صرف المخازن.
2. **إضافة المسارات**: إضافة مسارات (routes) لعمليات CRUD الخاصة بإذن صرف المخازن.
3. **اختبار النظام**: اختبار عمليات إنشاء وعرض وتعديل وحذف إذن صرف المخازن.
4. **إضافة الصلاحيات للمستخدمين**: إضافة الصلاحيات الجديدة للمستخدمين المناسبين.

## الملفات الرئيسية

1. **ملف الهجرة**: `database/migrations/2023_08_15_000001_create_inventory_issues_table.php`
2. **نموذج البيانات**: `app/Models/InventoryIssue.php`
3. **المتحكم**: `app/Http/Controllers/InventoryIssueController.php`
4. **ملف بذور الصلاحيات**: `database/seeders/InventoryIssuePermissionsSeeder.php`