---
description: هيكل قاعدة بيانات نظام إدارة شركات المصاعد
alwaysApply: true
---
هام جدا 
لا تحذف ابدا قاعدة البيانات قبل الرجوع الي مديرالمشروع 
# هيكل قاعدة بيانات نظام إدارة شركات المصاعد (Elevators ERP)

## مقدمة

يوثق هذا المستند هيكل قاعدة بيانات نظام إدارة شركات المصاعد، بما في ذلك الجداول والعلاقات والحقول. يهدف هذا التوثيق إلى مساعدة المطورين على فهم كيفية تنظيم البيانات وكيفية الوصول إليها.

## نظرة عامة على قاعدة البيانات

قاعدة البيانات مصممة لدعم نظام SaaS متعدد المستأجرين، حيث يتم تخزين بيانات جميع الشركات في نفس قاعدة البيانات، ولكن يتم فصلها منطقيًا باستخدام حقل `company_id` في جميع الجداول ذات الصلة. تستخدم قاعدة البيانات MySQL وتتبع مبادئ التصميم العلائقي مع تطبيق القيود والمفاتيح الخارجية لضمان سلامة البيانات.

## الجداول الرئيسية

النظام يتكون من أكثر من 30 جدول مترابط، مقسمة إلى عدة مجموعات وظيفية:

1. **جداول إدارة النظام**: المستخدمين، الشركات، الفروع، الأدوار، الصلاحيات
2. **جداول إدارة العملاء**: العملاء، المواقع، تفاعلات العملاء، الفرص التجارية
3. **جداول إدارة المصاعد**: المصاعد، عقود الصيانة، جداول الصيانة، سجلات الصيانة
4. **جداول إدارة الفواتير**: الفواتير، بنود الفواتير، المدفوعات، طرق الدفع
5. **جداول إدارة المخزون**: المستودعات، عناصر المخزون، فئات المخزون، مخزون المستودعات، الدفعات، الأرقام التسلسلية، حركات المخزون
6. **جداول إدارة المشتريات**: الموردين، أوامر الشراء، بنود أوامر الشراء، قواعد الشراء التلقائي
7. **جداول نظام الولاء**: نقاط الولاء، مكافآت العملاء
8. **جداول التتبع والسجلات**: سجل النشاطات، سجل تسجيل الدخول

### 1. جدول المستخدمين (users)

يخزن معلومات المستخدمين وبيانات المصادقة.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم المستخدم |
| email | varchar(255) | البريد الإلكتروني (فريد) |
| email_verified_at | timestamp | وقت التحقق من البريد الإلكتروني |
| password | varchar(255) | كلمة المرور المشفرة |
| company_id | bigint | المفتاح الخارجي للشركة |
| branch_id | bigint | المفتاح الخارجي للفرع |
| two_factor_secret | text | سر المصادقة الثنائية |
| two_factor_recovery_codes | text | رموز استرداد المصادقة الثنائية |
| two_factor_confirmed_at | timestamp | وقت تأكيد المصادقة الثنائية |
| remember_token | varchar(100) | رمز تذكر المستخدم |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 2. جدول الشركات (companies)

يخزن معلومات الشركات المستخدمة للنظام.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم الشركة |
| address | text | عنوان الشركة |
| phone | varchar(255) | رقم هاتف الشركة |
| email | varchar(255) | البريد الإلكتروني للشركة |
| logo | varchar(255) | مسار شعار الشركة |
| tax_number | varchar(255) | الرقم الضريبي |
| subscription_plan | varchar(255) | خطة الاشتراك |
| subscription_ends_at | timestamp | تاريخ انتهاء الاشتراك |
| currency | varchar(255) | العملة المستخدمة |
| tax_rate | decimal(5,2) | نسبة الضريبة |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 3. جدول الفروع (branches)

يخزن معلومات فروع الشركات.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم الفرع |
| address | text | عنوان الفرع |
| phone | varchar(255) | رقم هاتف الفرع |
| email | varchar(255) | البريد الإلكتروني للفرع |
| company_id | bigint | المفتاح الخارجي للشركة |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 4. جدول الأدوار (roles)

يخزن الأدوار المتاحة في النظام.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم الدور |
| display_name | varchar(255) | اسم العرض للدور |
| description | text | وصف الدور |
| level | varchar(255) | مستوى الدور (system, company, branch) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 5. جدول الصلاحيات (permissions)

يخزن الصلاحيات المتاحة في النظام.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم الصلاحية |
| display_name | varchar(255) | اسم العرض للصلاحية |
| description | text | وصف الصلاحية |
| level | varchar(255) | مستوى الصلاحية (system, company, branch) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 6. جدول العملاء (customers)

يخزن معلومات العملاء.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم العميل |
| contact_person | varchar(255) | الشخص المسؤول |
| phone | varchar(255) | رقم الهاتف |
| email | varchar(255) | البريد الإلكتروني |
| address | text | العنوان |
| tax_number | varchar(255) | الرقم الضريبي |
| company_id | bigint | المفتاح الخارجي للشركة |
| user_id | bigint | المفتاح الخارجي للمستخدم الذي أنشأ العميل |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 7. جدول المواقع (locations)

يخزن معلومات مواقع المصاعد.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم الموقع |
| address | text | عنوان الموقع |
| city | varchar(255) | المدينة |
| state | varchar(255) | المنطقة/المحافظة |
| postal_code | varchar(255) | الرمز البريدي |
| latitude | decimal(10,8) | خط العرض |
| longitude | decimal(11,8) | خط الطول |
| customer_id | bigint | المفتاح الخارجي للعميل |
| company_id | bigint | المفتاح الخارجي للشركة |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 8. جدول المصاعد (elevators)

يخزن معلومات المصاعد.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| model | varchar(255) | موديل المصعد |
| serial_number | varchar(255) | الرقم التسلسلي |
| installation_date | date | تاريخ التركيب |
| capacity | decimal(8,2) | السعة (كجم) |
| speed | decimal(5,2) | السرعة (م/ث) |
| floors | integer | عدد الطوابق |
| manufacturer | varchar(255) | الشركة المصنعة |
| customer_id | bigint | المفتاح الخارجي للعميل |
| location_id | bigint | المفتاح الخارجي للموقع |
| company_id | bigint | المفتاح الخارجي للشركة |
| user_id | bigint | المفتاح الخارجي للمستخدم الذي أنشأ المصعد |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 9. جدول عقود الصيانة (maintenance_contracts)

يخزن معلومات عقود الصيانة.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| contract_number | varchar(255) | رقم العقد |
| start_date | date | تاريخ بدء العقد |
| end_date | date | تاريخ انتهاء العقد |
| amount | decimal(10,2) | قيمة العقد |
| frequency | varchar(255) | تكرار الصيانة (شهري، ربع سنوي، سنوي) |
| terms | text | شروط العقد |
| status | varchar(255) | حالة العقد (نشط، منتهي، ملغى) |
| customer_id | bigint | المفتاح الخارجي للعميل |
| company_id | bigint | المفتاح الخارجي للشركة |
| user_id | bigint | المفتاح الخارجي للمستخدم الذي أنشأ العقد |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 10. جدول ربط العقود بالمصاعد (contract_elevator)

جدول وسيط لربط عقود الصيانة بالمصاعد (علاقة العديد للعديد).

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| maintenance_contract_id | bigint | المفتاح الخارجي لعقد الصيانة |
| elevator_id | bigint | المفتاح الخارجي للمصعد |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 11. جدول الفواتير (invoices)

يخزن معلومات الفواتير.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| invoice_number | varchar(255) | رقم الفاتورة |
| date | date | تاريخ الفاتورة |
| due_date | date | تاريخ الاستحقاق |
| subtotal | decimal(10,2) | المجموع الفرعي |
| tax_amount | decimal(10,2) | مبلغ الضريبة |
| total | decimal(10,2) | المجموع الكلي |
| status | varchar(255) | حالة الفاتورة (مدفوعة، غير مدفوعة، مدفوعة جزئيًا) |
| notes | text | ملاحظات |
| customer_id | bigint | المفتاح الخارجي للعميل |
| maintenance_contract_id | bigint | المفتاح الخارجي لعقد الصيانة (اختياري) |
| company_id | bigint | المفتاح الخارجي للشركة |
| user_id | bigint | المفتاح الخارجي للمستخدم الذي أنشأ الفاتورة |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 12. جدول بنود الفواتير (invoice_items)

يخزن بنود الفواتير.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| description | text | وصف البند |
| quantity | decimal(8,2) | الكمية |
| unit_price | decimal(10,2) | سعر الوحدة |
| tax_rate | decimal(5,2) | نسبة الضريبة |
| tax_amount | decimal(10,2) | مبلغ الضريبة |
| subtotal | decimal(10,2) | المجموع الفرعي |
| total | decimal(10,2) | المجموع الكلي |
| invoice_id | bigint | المفتاح الخارجي للفاتورة |
| elevator_id | bigint | المفتاح الخارجي للمصعد (اختياري) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 13. جدول طرق الدفع (payment_methods)

يخزن طرق الدفع المتاحة.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| name | varchar(255) | اسم طريقة الدفع |
| description | text | وصف طريقة الدفع |
| company_id | bigint | المفتاح الخارجي للشركة |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 14. جدول المدفوعات (payments)

يخزن معلومات المدفوعات.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| amount | decimal(10,2) | مبلغ الدفعة |
| date | date | تاريخ الدفع |
| reference | varchar(255) | رقم المرجع |
| notes | text | ملاحظات |
| invoice_id | bigint | المفتاح الخارجي للفاتورة |
| payment_method_id | bigint | المفتاح الخارجي لطريقة الدفع |
| company_id | bigint | المفتاح الخارجي للشركة |
| user_id | bigint | المفتاح الخارجي للمستخدم الذي سجل الدفعة |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 15. جدول سجل النشاطات (activity_logs)

يخزن سجل نشاطات المستخدمين.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| user_id | bigint | المفتاح الخارجي للمستخدم |
| action | varchar(255) | الإجراء المتخذ |
| model_type | varchar(255) | نوع النموذج |
| model_id | bigint | معرف النموذج |
| description | text | وصف النشاط |
| old_values | json | القيم القديمة |
| new_values | json | القيم الجديدة |
| ip_address | varchar(45) | عنوان IP |
| user_agent | text | وكيل المستخدم |
| company_id | bigint | المفتاح الخارجي للشركة |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 16. جدول سجل تسجيل الدخول (login_history)

يخزن سجل عمليات تسجيل الدخول.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| user_id | bigint | المفتاح الخارجي للمستخدم |
| ip_address | varchar(45) | عنوان IP |
| user_agent | text | وكيل المستخدم |
| login_at | timestamp | وقت تسجيل الدخول |
| logout_at | timestamp | وقت تسجيل الخروج |
| status | varchar(255) | حالة تسجيل الدخول (نجاح، فشل) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 17. جدول تفاعلات العملاء (customer_interactions)

يخزن سجل التفاعلات مع العملاء.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| customer_id | bigint | المفتاح الخارجي للعميل |
| user_id | bigint | المفتاح الخارجي للمستخدم |
| type | varchar(255) | نوع التفاعل (اتصال، زيارة، بريد إلكتروني، إلخ) |
| title | varchar(255) | عنوان التفاعل |
| description | text | وصف التفاعل |
| interaction_date | timestamp | تاريخ التفاعل |
| follow_up_date | timestamp | تاريخ المتابعة |
| status | varchar(255) | حالة التفاعل |
| outcome | text | نتيجة التفاعل |
| notes | text | ملاحظات |
| deleted_at | timestamp | وقت الحذف (للحذف الناعم) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 18. جدول الفرص التجارية (opportunities)

يخزن معلومات الفرص التجارية.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| customer_id | bigint | المفتاح الخارجي للعميل |
| user_id | bigint | المفتاح الخارجي للمستخدم |
| name | varchar(255) | اسم الفرصة |
| description | text | وصف الفرصة |
| amount | decimal(10,2) | قيمة الفرصة |
| stage | varchar(255) | مرحلة الفرصة (جديدة، متابعة، مفاوضات، مغلقة) |
| probability | integer | احتمالية النجاح (%) |
| expected_close_date | date | تاريخ الإغلاق المتوقع |
| actual_close_date | date | تاريخ الإغلاق الفعلي |
| source | varchar(255) | مصدر الفرصة |
| notes | text | ملاحظات |
| deleted_at | timestamp | وقت الحذف (للحذف الناعم) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 19. جدول نقاط الولاء (loyalty_points)

يخزن معلومات نقاط الولاء للعملاء.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| customer_id | bigint | المفتاح الخارجي للعميل |
| points | integer | عدد النقاط |
| type | varchar(255) | نوع النقاط (مكتسبة، مستخدمة، منتهية) |
| amount | integer | المبلغ المرتبط بالنقاط |
| source | varchar(255) | مصدر النقاط (فاتورة، عقد، إلخ) |
| source_id | bigint | معرف المصدر |
| description | text | وصف النقاط |
| expiry_date | date | تاريخ انتهاء النقاط |
| deleted_at | timestamp | وقت الحذف (للحذف الناعم) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 20. جدول مكافآت العملاء (customer_rewards)

يخزن معلومات المكافآت المتاحة للعملاء.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| name | varchar(255) | اسم المكافأة |
| description | text | وصف المكافأة |
| type | varchar(255) | نوع المكافأة (خصم، هدية، خدمة مجانية) |
| points_required | integer | النقاط المطلوبة |
| discount_amount | decimal(10,2) | مبلغ الخصم |
| discount_percentage | integer | نسبة الخصم |
| start_date | date | تاريخ بدء المكافأة |
| end_date | date | تاريخ انتهاء المكافأة |
| status | varchar(255) | حالة المكافأة (نشطة، غير نشطة) |
| usage_limit | integer | حد الاستخدام |
| usage_count | integer | عدد مرات الاستخدام |
| terms_conditions | text | الشروط والأحكام |
| deleted_at | timestamp | وقت الحذف (للحذف الناعم) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

## العلاقات الرئيسية بين الجداول

### علاقات إدارة النظام
- **الشركة والفروع**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Company (1) --- (*) Branch
  ```
- **المستخدم والشركة والفرع**: علاقة متعدد لواحد (Many-to-One)
  ```
  User (*) --- (1) Company
  User (*) --- (1) Branch
  ```
- **المستخدم والأدوار**: علاقة متعدد لمتعدد (Many-to-Many)
  ```
  User (*) --- (*) Role
  ```
- **الأدوار والصلاحيات**: علاقة متعدد لمتعدد (Many-to-Many)
  ```
  Role (*) --- (*) Permission
  ```

### علاقات إدارة العملاء والمصاعد
- **العميل والمواقع**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Customer (1) --- (*) Location
  ```
- **العميل والمصاعد**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Customer (1) --- (*) Elevator
  ```
- **الموقع والمصاعد**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Location (1) --- (*) Elevator
  ```
- **عقد الصيانة والمصاعد**: علاقة متعدد لمتعدد (Many-to-Many)
  ```
  MaintenanceContract (*) --- (*) Elevator
  ```

### علاقات إدارة الفواتير
- **العميل والفواتير**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Customer (1) --- (*) Invoice
  ```
- **الفاتورة وبنود الفاتورة**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Invoice (1) --- (*) InvoiceItem
  ```
- **الفاتورة والمدفوعات**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Invoice (1) --- (*) Payment
  ```

### علاقات إدارة المخزون
- **المستودع ومخزون المستودعات**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Warehouse (1) --- (*) InventoryStock
  ```
- **عنصر المخزون وفئة المخزون**: علاقة متعدد لواحد (Many-to-One)
  ```
  InventoryItem (*) --- (1) InventoryCategory
  ```
- **عنصر المخزون ومخزون المستودعات**: علاقة واحد لمتعدد (One-to-Many)
  ```
  InventoryItem (1) --- (*) InventoryStock
  ```
- **عنصر المخزون والدفعات**: علاقة واحد لمتعدد (One-to-Many)
  ```
  InventoryItem (1) --- (*) InventoryBatch
  ```
- **عنصر المخزون والأرقام التسلسلية**: علاقة واحد لمتعدد (One-to-Many)
  ```
  InventoryItem (1) --- (*) InventorySerial
  ```
- **الدفعة والأرقام التسلسلية**: علاقة واحد لمتعدد (One-to-Many)
  ```
  InventoryBatch (1) --- (*) InventorySerial
  ```

### علاقات إدارة المشتريات
- **المورد وأوامر الشراء**: علاقة واحد لمتعدد (One-to-Many)
  ```
  Supplier (1) --- (*) PurchaseOrder
  ```
- **أمر الشراء وبنود أمر الشراء**: علاقة واحد لمتعدد (One-to-Many)
  ```
  PurchaseOrder (1) --- (*) PurchaseOrderItem
  ```
- **عنصر المخزون وبنود أمر الشراء**: علاقة واحد لمتعدد (One-to-Many)
  ```
  InventoryItem (1) --- (*) PurchaseOrderItem
  ```
- **قاعدة الشراء التلقائي وأوامر الشراء**: علاقة واحد لمتعدد (One-to-Many)
  ```
  AutoPurchaseRule (1) --- (*) PurchaseOrder
  ```

## مخطط قاعدة البيانات المبسط

```
+-------------+     +------------+     +--------------+
|  Companies  |<----+  Branches  |<----+    Users     |
+-------------+     +------------+     +--------------+
       ^                                      ^
       |                                      |
       v                                      v
+-------------+     +------------+     +--------------+
|  Customers  |<----+  Locations |<----+   Elevators  |
+-------------+     +------------+     +--------------+
       ^                                      ^
       |                                      |
       v                                      v
+-------------+     +------------+     +--------------+
|   Invoices  |<----+ InvoiceItems|     | Maintenance  |
+-------------+     +------------+     | Contracts    |
       ^                                +--------------+
       |                                      ^
       v                                      |
+-------------+                         +--------------+
|  Payments   |                         | Maintenance  |
+-------------+                         | Schedules    |
                                        +--------------+
+-------------+     +------------+     +--------------+
| Warehouses  |<----+ Inventory  |<----+ Inventory    |
+-------------+     | Stocks     |     | Items        |
       ^            +------------+     +--------------+
       |                  ^                   ^
       v                  |                   |
+-------------+     +------------+     +--------------+
|  Suppliers  |<----+ Purchase   |<----+ Purchase     |
+-------------+     | Orders     |     | Order Items  |
       ^            +------------+     +--------------+
       |                  ^
       v                  |
+-------------+     +------------+
| Inventory   |     | Auto       |
| Transactions|     | Purchase   |
+-------------+     | Rules      |
                    +------------+
```

### 21. جدول المستودعات (warehouses)

يخزن معلومات المستودعات.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| branch_id | bigint | المفتاح الخارجي للفرع |
| name | varchar(255) | اسم المستودع |
| code | varchar(255) | رمز المستودع |
| address | text | عنوان المستودع |
| manager_name | varchar(255) | اسم مدير المستودع |
| phone | varchar(255) | رقم هاتف المستودع |
| email | varchar(255) | البريد الإلكتروني للمستودع |
| is_active | boolean | حالة المستودع (نشط، غير نشط) |
| notes | text | ملاحظات |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 22. جدول الموردين (suppliers)

يخزن معلومات الموردين.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| name | varchar(255) | اسم المورد |
| code | varchar(255) | رمز المورد |
| contact_person | varchar(255) | الشخص المسؤول |
| phone | varchar(255) | رقم الهاتف |
| email | varchar(255) | البريد الإلكتروني |
| website | varchar(255) | الموقع الإلكتروني |
| address | text | العنوان |
| tax_number | varchar(255) | الرقم الضريبي |
| commercial_register | varchar(255) | السجل التجاري |
| rating | integer | تقييم المورد |
| is_active | boolean | حالة المورد (نشط، غير نشط) |
| notes | text | ملاحظات |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 23. جدول عناصر المخزون (inventory_items)

يخزن معلومات عناصر المخزون.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| category_id | bigint | المفتاح الخارجي لفئة المخزون |
| name | varchar(255) | اسم العنصر |
| sku | varchar(255) | رمز العنصر |
| barcode | varchar(255) | الباركود |
| description | text | وصف العنصر |
| unit | varchar(255) | وحدة القياس |
| purchase_price | decimal(10,2) | سعر الشراء |
| selling_price | decimal(10,2) | سعر البيع |
| min_stock_level | decimal(10,2) | الحد الأدنى للمخزون |
| max_stock_level | decimal(10,2) | الحد الأقصى للمخزون |
| track_serial_numbers | boolean | تتبع الأرقام التسلسلية |
| track_batches | boolean | تتبع الدفعات |
| is_active | boolean | حالة العنصر (نشط، غير نشط) |
| image | varchar(255) | صورة العنصر |
| technical_specs | text | المواصفات الفنية |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 24. جدول فئات المخزون (inventory_categories)

يخزن معلومات فئات المخزون.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| parent_id | bigint | المفتاح الخارجي للفئة الأب |
| name | varchar(255) | اسم الفئة |
| description | text | وصف الفئة |
| is_active | boolean | حالة الفئة (نشطة، غير نشطة) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 25. جدول مخزون المستودعات (inventory_stocks)

يخزن معلومات مخزون المستودعات.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| warehouse_id | bigint | المفتاح الخارجي للمستودع |
| item_id | bigint | المفتاح الخارجي للعنصر |
| quantity | decimal(10,2) | الكمية |
| reserved_quantity | decimal(10,2) | الكمية المحجوزة |
| location_code | varchar(255) | رمز الموقع داخل المستودع |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 26. جدول دفعات المخزون (inventory_batches)

يخزن معلومات دفعات المخزون.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| warehouse_id | bigint | المفتاح الخارجي للمستودع |
| item_id | bigint | المفتاح الخارجي للعنصر |
| batch_number | varchar(255) | رقم الدفعة |
| quantity | decimal(10,2) | الكمية |
| manufacturing_date | date | تاريخ التصنيع |
| expiry_date | date | تاريخ انتهاء الصلاحية |
| purchase_price | decimal(10,2) | سعر الشراء |
| supplier_id | bigint | المفتاح الخارجي للمورد |
| notes | text | ملاحظات |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 27. جدول الأرقام التسلسلية (inventory_serials)

يخزن معلومات الأرقام التسلسلية للمخزون.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| warehouse_id | bigint | المفتاح الخارجي للمستودع |
| item_id | bigint | المفتاح الخارجي للعنصر |
| batch_id | bigint | المفتاح الخارجي للدفعة |
| serial_number | varchar(255) | الرقم التسلسلي |
| status | varchar(255) | الحالة (متاح، مباع، معيب) |
| purchase_date | date | تاريخ الشراء |
| warranty_expiry | date | تاريخ انتهاء الضمان |
| purchase_price | decimal(10,2) | سعر الشراء |
| supplier_id | bigint | المفتاح الخارجي للمورد |
| notes | text | ملاحظات |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 28. جدول حركات المخزون (inventory_transactions)

يخزن معلومات حركات المخزون.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| transaction_type | varchar(255) | نوع الحركة (شراء، بيع، تحويل، إلخ) |
| item_id | bigint | المفتاح الخارجي للعنصر |
| warehouse_id | bigint | المفتاح الخارجي للمستودع المصدر |
| to_warehouse_id | bigint | المفتاح الخارجي للمستودع الهدف (للتحويلات) |
| quantity | decimal(10,2) | الكمية |
| unit_price | decimal(10,2) | سعر الوحدة |
| reference_number | varchar(255) | رقم المرجع |
| reference_type | varchar(255) | نوع المرجع (أمر شراء، فاتورة، إلخ) |
| reference_id | bigint | معرف المرجع |
| batch_id | bigint | المفتاح الخارجي للدفعة |
| serial_id | bigint | المفتاح الخارجي للرقم التسلسلي |
| created_by | bigint | المفتاح الخارجي للمستخدم الذي أنشأ الحركة |
| notes | text | ملاحظات |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 29. جدول تقييم المخزون (inventory_valuations)

يخزن معلومات تقييم المخزون.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| item_id | bigint | المفتاح الخارجي للعنصر |
| warehouse_id | bigint | المفتاح الخارجي للمستودع |
| valuation_date | date | تاريخ التقييم |
| quantity | decimal(10,2) | الكمية |
| unit_cost | decimal(10,2) | تكلفة الوحدة |
| total_cost | decimal(10,2) | التكلفة الإجمالية |
| valuation_method | varchar(255) | طريقة التقييم (FIFO, LIFO, Average) |
| reference_type | varchar(255) | نوع المرجع |
| reference_id | bigint | معرف المرجع |
| created_by | bigint | المفتاح الخارجي للمستخدم الذي أنشأ التقييم |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 30. جدول أوامر الشراء (purchase_orders)

يخزن معلومات أوامر الشراء.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| supplier_id | bigint | المفتاح الخارجي للمورد |
| warehouse_id | bigint | المفتاح الخارجي للمستودع |
| created_by | bigint | المفتاح الخارجي للمستخدم الذي أنشأ الأمر |
| po_number | varchar(255) | رقم أمر الشراء |
| order_date | date | تاريخ الطلب |
| expected_delivery_date | date | تاريخ التسليم المتوقع |
| delivery_date | date | تاريخ التسليم الفعلي |
| status | varchar(255) | حالة الأمر (مسودة، معلق، مؤكد، مستلم، ملغى) |
| subtotal | decimal(10,2) | المجموع الفرعي |
| tax_amount | decimal(10,2) | مبلغ الضريبة |
| discount_amount | decimal(10,2) | مبلغ الخصم |
| total_amount | decimal(10,2) | المبلغ الإجمالي |
| payment_terms | varchar(255) | شروط الدفع |
| shipping_method | varchar(255) | طريقة الشحن |
| notes | text | ملاحظات |
| internal_notes | text | ملاحظات داخلية |
| approved_by | bigint | المفتاح الخارجي للمستخدم الذي وافق على الأمر |
| approved_at | timestamp | وقت الموافقة |
| auto_purchase_rule_id | bigint | المفتاح الخارجي لقاعدة الشراء التلقائي |
| is_auto_generated | boolean | هل تم إنشاؤه تلقائيًا |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 31. جدول بنود أوامر الشراء (purchase_order_items)

يخزن معلومات بنود أوامر الشراء.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| purchase_order_id | bigint | المفتاح الخارجي لأمر الشراء |
| item_id | bigint | المفتاح الخارجي للعنصر |
| quantity | decimal(10,2) | الكمية المطلوبة |
| received_quantity | decimal(10,2) | الكمية المستلمة |
| unit_price | decimal(10,2) | سعر الوحدة |
| tax_rate | decimal(5,2) | نسبة الضريبة |
| discount_amount | decimal(10,2) | مبلغ الخصم |
| total_amount | decimal(10,2) | المبلغ الإجمالي |
| notes | text | ملاحظات |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 32. جدول قواعد الشراء التلقائي (auto_purchase_rules)

يخزن معلومات قواعد الشراء التلقائي.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| item_id | bigint | المفتاح الخارجي للعنصر |
| supplier_id | bigint | المفتاح الخارجي للمورد |
| warehouse_id | bigint | المفتاح الخارجي للمستودع |
| min_quantity | decimal(10,2) | الحد الأدنى للكمية |
| order_quantity | decimal(10,2) | كمية الطلب |
| frequency_days | integer | عدد أيام التكرار |
| last_triggered_at | timestamp | وقت آخر تشغيل |
| next_check_date | date | تاريخ الفحص التالي |
| is_active | boolean | حالة القاعدة (نشطة، غير نشطة) |
| created_by | bigint | المفتاح الخارجي للمستخدم الذي أنشأ القاعدة |
| updated_by | bigint | المفتاح الخارجي للمستخدم الذي حدث القاعدة |
| deleted_at | timestamp | وقت الحذف (للحذف الناعم) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |
| updated_at | timestamp | وقت التحديث |

### 21. جدول استخدام المكافآت (reward_redemptions)

يخزن معلومات استخدام المكافآت.

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| company_id | bigint | المفتاح الخارجي للشركة |
| customer_id | bigint | المفتاح الخارجي للعميل |
| reward_id | bigint | المفتاح الخارجي للمكافأة |
| points_used | integer | النقاط المستخدمة |
| discount_amount | decimal(10,2) | مبلغ الخصم |
| discount_percentage | integer | نسبة الخصم |
| invoice_id | bigint | المفتاح الخارجي للفاتورة |
| notes | text | ملاحظات |
| redeemed_at | timestamp | وقت الاستخدام |
| status | varchar(255) | حالة الاستخدام (معلق، مطبق، ملغى) |
| deleted_at | timestamp | وقت الحذف (للحذف الناعم) |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

## جداول العلاقات

### 1. جدول علاقة الأدوار بالمستخدمين (role_user)

يربط بين المستخدمين والأدوار (علاقة العديد للعديد).

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| user_id | bigint | المفتاح الخارجي للمستخدم |
| role_id | bigint | المفتاح الخارجي للدور |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 2. جدول علاقة الصلاحيات بالأدوار (permission_role)

يربط بين الأدوار والصلاحيات (علاقة العديد للعديد).

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| permission_id | bigint | المفتاح الخارجي للصلاحية |
| role_id | bigint | المفتاح الخارجي للدور |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

### 3. جدول صلاحيات المستخدمين (user_permission)

يربط بين المستخدمين والصلاحيات مباشرة (للصلاحيات الخاصة).

| الحقل | النوع | الوصف |
|-------|------|-------|
| id | bigint | المفتاح الأساسي |
| user_id | bigint | المفتاح الخارجي للمستخدم |
| permission_id | bigint | المفتاح الخارجي للصلاحية |
| created_at | timestamp | وقت الإنشاء |
| updated_at | timestamp | وقت التحديث |

## العلاقات بين الجداول

### علاقات المستخدمين
- المستخدم ينتمي إلى شركة واحدة (users.company_id -> companies.id)
- المستخدم ينتمي إلى فرع واحد (users.branch_id -> branches.id)
- المستخدم له عدة أدوار (users.id <- role_user.user_id -> role_user.role_id -> roles.id)
- المستخدم له عدة صلاحيات مباشرة (users.id <- user_permission.user_id -> user_permission.permission_id -> permissions.id)

### علاقات الشركات والفروع
- الشركة لها عدة فروع (companies.id <- branches.company_id)
- الشركة لها عدة مستخدمين (companies.id <- users.company_id)
- الشركة لها عدة عملاء (companies.id <- customers.company_id)
- الشركة لها عدة مصاعد (companies.id <- elevators.company_id)
- الشركة لها عدة عقود (companies.id <- maintenance_contracts.company_id)
- الشركة لها عدة فواتير (companies.id <- invoices.company_id)

### علاقات العملاء والمواقع
- العميل له عدة مواقع (customers.id <- locations.customer_id)
- العميل له عدة مصاعد (customers.id <- elevators.customer_id)
- العميل له عدة عقود (customers.id <- maintenance_contracts.customer_id)
- العميل له عدة فواتير (customers.id <- invoices.customer_id)
- العميل له عدة تفاعلات (customers.id <- customer_interactions.customer_id)
- العميل له عدة فرص تجارية (customers.id <- opportunities.customer_id)
- العميل له عدة نقاط ولاء (customers.id <- loyalty_points.customer_id)
- العميل له عدة استخدامات للمكافآت (customers.id <- reward_redemptions.customer_id)

### علاقات المصاعد
- المصعد ينتمي إلى عميل واحد (elevators.customer_id -> customers.id)
- المصعد ينتمي إلى موقع واحد (elevators.location_id -> locations.id)
- المصعد ينتمي إلى شركة واحدة (elevators.company_id -> companies.id)
- المصعد له عدة عقود (elevators.id <- contract_elevator.elevator_id -> contract_elevator.maintenance_contract_id -> maintenance_contracts.id)

### علاقات العقود
- العقد ينتمي إلى عميل واحد (maintenance_contracts.customer_id -> customers.id)
- العقد ينتمي إلى شركة واحدة (maintenance_contracts.company_id -> companies.id)
- العقد له عدة مصاعد (maintenance_contracts.id <- contract_elevator.maintenance_contract_id -> contract_elevator.elevator_id -> elevators.id)
- العقد له عدة فواتير (maintenance_contracts.id <- invoices.maintenance_contract_id)

### علاقات الفواتير
- الفاتورة تنتمي إلى عميل واحد (invoices.customer_id -> customers.id)
- الفاتورة تنتمي إلى شركة واحدة (invoices.company_id -> companies.id)
- الفاتورة قد تنتمي إلى عقد واحد (invoices.maintenance_contract_id -> maintenance_contracts.id)
- الفاتورة لها عدة بنود (invoices.id <- invoice_items.invoice_id)
- الفاتورة قد تكون مرتبطة باستخدام مكافأة (invoices.id <- reward_redemptions.invoice_id)

### علاقات نظام إدارة علاقات العملاء (CRM)
- تفاعل العميل ينتمي إلى عميل واحد (customer_interactions.customer_id -> customers.id)
- تفاعل العميل ينتمي إلى شركة واحدة (customer_interactions.company_id -> companies.id)
- تفاعل العميل ينتمي إلى مستخدم واحد (customer_interactions.user_id -> users.id)
- الفرصة التجارية تنتمي إلى عميل واحد (opportunities.customer_id -> customers.id)
- الفرصة التجارية تنتمي إلى شركة واحدة (opportunities.company_id -> companies.id)
- الفرصة التجارية تنتمي إلى مستخدم واحد (opportunities.user_id -> users.id)
- الفرصة التجارية لها عدة تفاعلات (opportunities.id <- customer_interactions.interactionable_id)

### علاقات نظام الولاء والمكافآت
- نقاط الولاء تنتمي إلى عميل واحد (loyalty_points.customer_id -> customers.id)
- نقاط الولاء تنتمي إلى شركة واحدة (loyalty_points.company_id -> companies.id)
- نقاط الولاء قد تكون مرتبطة بفاتورة (loyalty_points.source_id -> invoices.id)
- مكافأة العميل تنتمي إلى شركة واحدة (customer_rewards.company_id -> companies.id)
- مكافأة العميل لها عدة استخدامات (customer_rewards.id <- reward_redemptions.reward_id)
- استخدام المكافأة ينتمي إلى عميل واحد (reward_redemptions.customer_id -> customers.id)
- استخدام المكافأة ينتمي إلى شركة واحدة (reward_redemptions.company_id -> companies.id)
- استخدام المكافأة ينتمي إلى مكافأة واحدة (reward_redemptions.reward_id -> customer_rewards.id)
- استخدام المكافأة قد يكون مرتبطًا بفاتورة واحدة (reward_redemptions.invoice_id -> invoices.id)
- الفاتورة لها عدة مدفوعات (invoices.id <- payments.invoice_id)

## مخطط قاعدة البيانات

```
users 1--* role_user *--1 roles
roles 1--* permission_role *--1 permissions
users 1--* user_permission *--1 permissions
companies 1--* branches
companies 1--* users
companies 1--* customers
companies 1--* elevators
companies 1--* maintenance_contracts
companies 1--* invoices
customers 1--* locations
customers 1--* elevators
customers 1--* maintenance_contracts
customers 1--* invoices
elevators *--* maintenance_contracts (via contract_elevator)
maintenance_contracts 1--* invoices
invoices 1--* invoice_items
invoices 1--* payments
payment_methods 1--* payments
```

## استعلامات مفيدة

### 1. الحصول على جميع المصاعد لشركة معينة

```sql
SELECT e.*
FROM elevators e
WHERE e.company_id = :company_id;
```

### 2. الحصول على جميع المصاعد لعميل معين

```sql
SELECT e.*
FROM elevators e
WHERE e.customer_id = :customer_id;
```

### 3. الحصول على جميع العقود النشطة

```sql
SELECT mc.*
FROM maintenance_contracts mc
WHERE mc.status = 'active'
AND mc.company_id = :company_id;
```

### 4. الحصول على جميع المصاعد المرتبطة بعقد معين

```sql
SELECT e.*
FROM elevators e
JOIN contract_elevator ce ON e.id = ce.elevator_id
WHERE ce.maintenance_contract_id = :contract_id;
```

### 5. الحصول على جميع الفواتير غير المدفوعة

```sql
SELECT i.*
FROM invoices i
WHERE i.status = 'unpaid'
AND i.company_id = :company_id;
```

### 6. حساب إجمالي المدفوعات لفاتورة معينة

```sql
SELECT SUM(p.amount) as total_paid
FROM payments p
WHERE p.invoice_id = :invoice_id;
```

### 7. الحصول على جميع المستخدمين بدور معين

```sql
SELECT u.*
FROM users u
JOIN role_user ru ON u.id = ru.user_id
WHERE ru.role_id = :role_id
AND u.company_id = :company_id;
```

### 8. الحصول على جميع العقود التي ستنتهي خلال الشهر القادم

```sql
SELECT mc.*
FROM maintenance_contracts mc
WHERE mc.end_date BETWEEN CURRENT_DATE AND DATE_ADD(CURRENT_DATE, INTERVAL 1 MONTH)
AND mc.status = 'active'
AND mc.company_id = :company_id;
```

## ملاحظات هامة

1. **عزل البيانات**: يتم استخدام حقل `company_id` في معظم الجداول لعزل بيانات كل شركة.
2. **تتبع المستخدمين**: يتم استخدام حقل `user_id` في العديد من الجداول لتتبع المستخدم الذي قام بإنشاء أو تعديل السجل.
3. **الحذف**: يفضل استخدام الحذف المنطقي (soft delete) بدلاً من الحذف الفعلي للبيانات.
4. **العلاقات**: يجب الحفاظ على سلامة العلاقات بين الجداول باستخدام قيود المفاتيح الخارجية.
5. **الأداء**: يجب إنشاء فهارس (indexes) على الحقول المستخدمة بشكل متكرر في عمليات البحث والفرز.